/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import me.desht.pneumaticcraft.common.block.tubes.INetworkedModule;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ModuleNetworkManager {
    private static final Map<ResourceLocation, ModuleNetworkManager> INSTANCES = new HashMap<ResourceLocation, ModuleNetworkManager>();
    private final Map<TubeModule, Set<TubeModule>> connectionCache = new HashMap<TubeModule, Set<TubeModule>>();
    private boolean needInvalidate = false;

    public static ModuleNetworkManager getInstance(World w) {
        return INSTANCES.computeIfAbsent(w.func_201675_m().func_186058_p().getRegistryName(), dimId -> new ModuleNetworkManager());
    }

    Set<TubeModule> getConnectedModules(TubeModule module) {
        if (this.needInvalidate) {
            this.connectionCache.clear();
            this.needInvalidate = false;
        }
        return this.connectionCache.computeIfAbsent(module, this::computeConnections);
    }

    public void invalidateCache() {
        this.needInvalidate = true;
    }

    private Set<TubeModule> computeConnections(TubeModule module) {
        HashSet<TubeModule> modules = new HashSet<TubeModule>();
        HashSet<TileEntity> traversedTubes = new HashSet<TileEntity>();
        Stack<TileEntityPressureTube> pendingTubes = new Stack<TileEntityPressureTube>();
        pendingTubes.push(module.getTube());
        while (!pendingTubes.isEmpty()) {
            TileEntityPressureTube tube = (TileEntityPressureTube)pendingTubes.pop();
            for (TubeModule tubeModule : tube.modules) {
                if (!(tubeModule instanceof INetworkedModule) || module.getClass() != tubeModule.getClass()) continue;
                modules.add(tubeModule);
            }
            for (TubeModule tubeModule : Direction.field_199792_n) {
                TileEntity newTube = tube.getConnectedNeighbor((Direction)tubeModule);
                if (!(newTube instanceof TileEntityPressureTube) || traversedTubes.contains(newTube)) continue;
                pendingTubes.add((TileEntityPressureTube)newTube);
                traversedTubes.add(newTube);
            }
        }
        return modules;
    }
}

