/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetPlace;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class DroneAIPlace<W extends ProgWidgetAreaItemBase & ISidedWidget>
extends DroneAIBlockInteraction<W> {
    public DroneAIPlace(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.drone.world().func_180495_p(pos).func_185904_a().func_76222_j()) {
            boolean failedOnPlacement = false;
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (!(droneStack.func_77973_b() instanceof BlockItem) || !this.progWidget.isItemValidForFilters(droneStack)) continue;
                Direction side = ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.progWidget)).getSides());
                BlockPos placerPos = pos.func_177972_a(side);
                BlockRayTraceResult brtr = this.drone.world().func_217299_a(new RayTraceContext(PneumaticCraftUtils.getBlockCentre(placerPos), PneumaticCraftUtils.getBlockCentre(pos), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.drone.getFakePlayer()));
                BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext((PlayerEntity)this.drone.getFakePlayer(), Hand.MAIN_HAND, brtr));
                Block placingBlock = ((BlockItem)droneStack.func_77973_b()).func_179223_d();
                BlockState state = placingBlock.func_196258_a(ctx);
                if (this.worldCache.func_195585_a(null, state.func_196954_c((IBlockReader)this.drone.world(), pos))) {
                    if (state.func_196955_c((IWorldReader)this.drone.world(), pos)) {
                        return true;
                    }
                    this.drone.addDebugEntry("gui.progWidget.place.debug.cantPlaceBlock", pos);
                    failedOnPlacement = true;
                    continue;
                }
                this.drone.addDebugEntry("gui.progWidget.place.debug.entityInWay", pos);
                failedOnPlacement = true;
            }
            if (!failedOnPlacement) {
                this.abort();
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double distToBlock) {
        if (distToBlock < 2.0) {
            Direction side = ProgWidgetPlace.getDirForSides(((ISidedWidget)((Object)this.progWidget)).getSides());
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (!(droneStack.func_77973_b() instanceof BlockItem) || !this.progWidget.isItemValidForFilters(droneStack)) continue;
                BlockItem blockItem = (BlockItem)droneStack.func_77973_b();
                BlockRayTraceResult brtr = this.drone.world().func_217299_a(new RayTraceContext(PneumaticCraftUtils.getBlockCentre(pos), PneumaticCraftUtils.getBlockCentre(pos), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.drone.getFakePlayer()));
                BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext((PlayerEntity)this.drone.getFakePlayer(), Hand.MAIN_HAND, brtr));
                Block placingBlock = blockItem.func_179223_d();
                BlockState state = placingBlock.func_196258_a(ctx);
                ActionResultType res = blockItem.func_195942_a(ctx);
                if (res != ActionResultType.SUCCESS) continue;
                this.drone.getCapability(PNCCapabilities.AIR_HANDLER_CAPABILITY).ifPresent(h -> h.addAir(-100));
                SoundType soundType = placingBlock.getSoundType(state, (IWorldReader)this.drone.world(), pos, (Entity)this.drone.getFakePlayer());
                this.drone.world().func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f, false);
                if (i == 0 && this.drone.getInv().getStackInSlot(i).func_190926_b()) {
                    this.drone.getInv().setStackInSlot(i, ItemStack.field_190927_a);
                }
                return false;
            }
            return false;
        }
        return true;
    }
}

