/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import net.minecraft.client.gui.FontRenderer;

public class WidgetComboBox
extends WidgetTextField
implements IDrawAfterRender {
    private final ArrayList<String> elements = new ArrayList();
    private final FontRenderer fontRenderer;
    private boolean enabled = true;
    private boolean fixedOptions;
    private boolean shouldSort = true;
    private int selectedIndex = -1;
    private final int baseHeight;
    private final Consumer<WidgetComboBox> pressable;
    private List<String> applicable = null;

    public WidgetComboBox(FontRenderer fontRenderer, int x, int y, int width, int height) {
        this(fontRenderer, x, y, width, height, b -> {});
    }

    public WidgetComboBox(FontRenderer fontRenderer, int x, int y, int width, int height, Consumer<WidgetComboBox> pressable) {
        super(fontRenderer, x, y, width, height);
        this.fontRenderer = fontRenderer;
        this.baseHeight = height;
        this.pressable = pressable;
    }

    public WidgetComboBox setElements(Collection<String> elements) {
        this.elements.clear();
        this.elements.addAll(elements);
        if (this.shouldSort) {
            Collections.sort(this.elements);
        }
        return this;
    }

    public WidgetComboBox setElements(String[] elements) {
        this.elements.clear();
        this.elements.ensureCapacity(elements.length);
        this.elements.addAll(Arrays.asList(elements));
        if (this.shouldSort) {
            Collections.sort(this.elements);
        }
        return this;
    }

    public WidgetComboBox setShouldSort(boolean shouldSort) {
        this.shouldSort = shouldSort;
        return this;
    }

    private List<String> getApplicableElements() {
        this.applicable = this.elements.stream().filter(element -> this.fixedOptions || element.toLowerCase().contains(this.func_146179_b().toLowerCase())).collect(Collectors.toList());
        return this.applicable;
    }

    public void func_146191_b(String textToWrite) {
        super.func_146191_b(textToWrite);
        this.applicable = null;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTick) {
        super.renderButton(mouseX, mouseY, partialTick);
        this.fontRenderer.func_211126_b(this.isFocused() ? "\u25b2" : "\u25bc", (float)(this.x + this.width - 7), (float)(this.y + 1), 0xC0C0C0);
    }

    @Override
    public void renderAfterEverythingElse(int mouseX, int mouseY, float partialTick) {
        if (this.enabled && this.active && this.isFocused()) {
            List<String> applicableElements = this.getApplicableElements();
            int n = applicableElements.size();
            this.fontRenderer.getClass();
            WidgetComboBox.fill((int)(this.x - 1), (int)(this.y + this.height + 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 3 + n * 9), (int)-6250336);
            int n2 = applicableElements.size();
            this.fontRenderer.getClass();
            WidgetComboBox.fill((int)this.x, (int)(this.y + this.height + 1), (int)(this.x + this.width), (int)(this.y + this.height + 2 + n2 * 9), (int)-16777216);
            for (int i = 0; i < applicableElements.size(); ++i) {
                String element = applicableElements.get(i);
                String string = this.fontRenderer.func_78269_a(element, this.getWidth());
                float f = this.x + 4;
                this.fontRenderer.getClass();
                this.fontRenderer.func_175063_a(string, f, (float)(this.y + this.height + 2 + i * 9), 0xE0E0E0);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.func_146176_q() && this.active) {
            boolean flag;
            int n;
            if (this.isFocused()) {
                int n2 = this.getApplicableElements().size();
                this.fontRenderer.getClass();
                n = n2 * 9;
            } else {
                n = 0;
            }
            int h = this.baseHeight + n;
            boolean bl = flag = mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + h);
            if (flag) {
                if (mouseY < (double)(this.y + this.height)) {
                    this.setFocused(!this.isFocused());
                } else {
                    this.setFocused(false);
                    int n3 = (int)mouseY - this.y - this.height;
                    this.fontRenderer.getClass();
                    int i = n3 / 9;
                    if (i < this.getApplicableElements().size()) {
                        this.func_146180_a(this.getApplicableElements().get(i));
                        this.selectedIndex = i;
                        this.pressable.accept(this);
                    }
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        List<String> applicableElements;
        if (this.fixedOptions) {
            return false;
        }
        if (this.enabled && this.isFocused() && keyCode == 258 && (applicableElements = this.getApplicableElements()).size() > 0) {
            this.func_146180_a(applicableElements.get(0));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char key, int keyCode) {
        return !this.fixedOptions && super.charTyped(key, keyCode);
    }

    public void func_146184_c(boolean enabled) {
        super.func_146184_c(enabled);
        this.enabled = enabled;
    }

    public WidgetComboBox setFixedOptions() {
        this.fixedOptions = true;
        this.applicable = null;
        return this;
    }

    public int getSelectedElementIndex() {
        return this.selectedIndex;
    }

    public void selectElement(int index) {
        if (index >= 0 && index < this.elements.size()) {
            this.selectedIndex = index;
            this.func_146180_a(this.elements.get(index));
        }
    }
}

