/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode.compiler;

import java.util.ArrayList;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.FunctionExpression;
import org.openzen.zenscript.codemodel.expression.StorageCastExpression;
import org.openzen.zenscript.codemodel.statement.ReturnStatement;
import org.openzen.zenscript.javabytecode.compiler.JavaExpressionVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;

class ArrayInitializerHelper {
    ArrayInitializerHelper() {
    }

    static int[] getArraySizeLocationsProjected(int dimension, Type originArrayType, int originArrayLocation, JavaWriter javaWriter) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        javaWriter.loadObject(originArrayLocation);
        Type currentElementType = originArrayType;
        for (i = 0; i < dimension; ++i) {
            currentElementType = Type.getType((String)currentElementType.getDescriptor().substring(1));
            int location = javaWriter.local(Integer.TYPE);
            javaWriter.dup();
            javaWriter.arrayLength();
            javaWriter.storeInt(location);
            list.add(location);
            if (i >= dimension - 1) continue;
            javaWriter.iConst0();
            javaWriter.arrayLoad(currentElementType);
        }
        javaWriter.pop();
        int[] arraySizes = new int[list.size()];
        for (i = 0; i < list.size(); ++i) {
            arraySizes[i] = (Integer)list.get(i);
        }
        return arraySizes;
    }

    static int[] getArraySizeLocationsFromConstructor(int dimension, Expression[] arguments, JavaExpressionVisitor visitor) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < dimension; ++i) {
            int location = visitor.javaWriter.local(Integer.TYPE);
            arguments[i].accept(visitor);
            visitor.javaWriter.storeInt(location);
            list.add(location);
        }
        int[] arraySizes = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arraySizes[i] = (Integer)list.get(i);
        }
        return arraySizes;
    }

    static void visitProjected(JavaWriter javaWriter, int[] sizeLocations, int dim, int originArrayLocation, Type originArrayType, Type currentArrayType, InnermostFunction innermostFunction) {
        ArrayInitializerHelper.visitMultiDimArray(javaWriter, sizeLocations, dim, currentArrayType, (elementType, counterLocations) -> {
            javaWriter.loadObject(originArrayLocation);
            Type modifiedOriginArrayType = originArrayType;
            for (int location : counterLocations) {
                javaWriter.loadInt(location);
                modifiedOriginArrayType = Type.getType((String)modifiedOriginArrayType.getDescriptor().substring(1));
                javaWriter.arrayLoad(modifiedOriginArrayType);
            }
            innermostFunction.apply(elementType, counterLocations);
        });
    }

    static void visitMultiDimArrayWithDefaultValue(JavaWriter javaWriter, int[] sizeLocations, int dim, Type currentArrayType, int defaultLocation) {
        ArrayInitializerHelper.visitMultiDimArray(javaWriter, sizeLocations, new int[dim], dim, currentArrayType, (elementType, counterLocations) -> javaWriter.load(elementType, defaultLocation));
    }

    private static void visitMultiDimArray(JavaWriter javaWriter, int[] sizeLocations, int dim, Type currentArrayType, InnermostFunction innermostFunction) {
        ArrayInitializerHelper.visitMultiDimArray(javaWriter, sizeLocations, new int[dim], dim, currentArrayType, innermostFunction);
    }

    static boolean canBeInLined(Expression expression) {
        while (expression instanceof StorageCastExpression) {
            expression = ((StorageCastExpression)expression).value;
        }
        return expression instanceof FunctionExpression && ((FunctionExpression)expression).body instanceof ReturnStatement;
    }

    static void visitMultiDimArray(JavaWriter javaWriter, int[] sizeLocations, int[] counterLocations, int dim, Type currentArrayType, InnermostFunction innermostFunction) {
        Label begin = new Label();
        Label end = new Label();
        javaWriter.label(begin);
        int currentArraySizeLocation = sizeLocations[sizeLocations.length - dim];
        javaWriter.loadInt(currentArraySizeLocation);
        Type elementType = Type.getType((String)currentArrayType.getDescriptor().substring(1));
        javaWriter.newArray(elementType);
        int forLoopCounter = javaWriter.local(Integer.TYPE);
        javaWriter.iConst0();
        javaWriter.storeInt(forLoopCounter);
        counterLocations[counterLocations.length - dim] = forLoopCounter;
        Label loopStart = new Label();
        Label loopEnd = new Label();
        javaWriter.label(loopStart);
        javaWriter.loadInt(forLoopCounter);
        javaWriter.loadInt(currentArraySizeLocation);
        javaWriter.ifICmpGE(loopEnd);
        javaWriter.dup();
        javaWriter.loadInt(forLoopCounter);
        if (dim == 1) {
            innermostFunction.apply(elementType, counterLocations);
        } else {
            ArrayInitializerHelper.visitMultiDimArray(javaWriter, sizeLocations, counterLocations, dim - 1, elementType, innermostFunction);
        }
        javaWriter.arrayStore(elementType);
        javaWriter.iinc(forLoopCounter);
        javaWriter.goTo(loopStart);
        javaWriter.label(loopEnd);
        javaWriter.nameVariable(forLoopCounter, "i" + dim, loopStart, loopEnd, Type.getType(Integer.TYPE));
        javaWriter.label(end);
        for (int i = 0; i < sizeLocations.length; ++i) {
            javaWriter.nameVariable(sizeLocations[i], "size" + (sizeLocations.length - i), begin, end, Type.getType(Integer.TYPE));
        }
    }

    @FunctionalInterface
    public static interface InnermostFunction {
        public void apply(Type var1, int[] var2);
    }
}

