/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.type;

import java.util.List;
import java.util.Set;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.codemodel.type.GlobalTypeRegistry;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.TypeVisitor;
import org.openzen.zenscript.codemodel.type.TypeVisitorWithContext;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;

public class RangeTypeID
implements TypeID {
    public static final RangeTypeID INT = new RangeTypeID(null, BasicTypeID.INT.stored);
    public static final RangeTypeID USIZE = new RangeTypeID(null, BasicTypeID.USIZE.stored);
    public final StoredType baseType;
    private final RangeTypeID normalized;
    public final StoredType stored;

    public RangeTypeID(GlobalTypeRegistry registry, StoredType baseType) {
        this.baseType = baseType;
        this.normalized = baseType.getNormalized().equals(baseType) ? this : registry.getRange(baseType.getNormalized());
        this.stored = new StoredType(this, baseType.getSpecifiedStorage());
    }

    @Override
    public RangeTypeID getNormalized() {
        return this.normalized;
    }

    @Override
    public StoredType instance(GenericMapper mapper, StorageTag storage) {
        return mapper.registry.getRange(this.baseType.instance(mapper)).stored(storage);
    }

    @Override
    public <R> R accept(TypeVisitor<R> visitor) {
        return visitor.visitRange(this);
    }

    @Override
    public <C, R, E extends Exception> R accept(C context, TypeVisitorWithContext<C, R, E> visitor) throws E {
        return visitor.visitRange(context, this);
    }

    @Override
    public boolean isOptional() {
        return false;
    }

    @Override
    public boolean isValueType() {
        return this.baseType.type.isValueType();
    }

    @Override
    public boolean isDestructible() {
        return this.baseType.isDestructible();
    }

    @Override
    public boolean isDestructible(Set<HighLevelDefinition> scanning) {
        return this.baseType.isDestructible(scanning);
    }

    @Override
    public boolean hasInferenceBlockingTypeParameters(TypeParameter[] parameters) {
        return this.baseType.hasInferenceBlockingTypeParameters(parameters);
    }

    @Override
    public boolean hasDefaultValue() {
        return false;
    }

    @Override
    public void extractTypeParameters(List<TypeParameter> typeParameters) {
        this.baseType.type.extractTypeParameters(typeParameters);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + this.baseType.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RangeTypeID other = (RangeTypeID)obj;
        return this.baseType.equals(other.baseType);
    }

    public String toString() {
        return this.baseType.toString() + " .. " + this.baseType.toString();
    }
}

