/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.brackets;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotations.BracketValidator;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketValidators")
public class BracketValidators {
    private BracketValidators() {
    }

    @ZenCodeType.Method
    @BracketValidator(value="item")
    public static boolean validateItemBracket(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.logWarning("Item BEP <item:%s> does not seem to be lower-cased!", tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            CraftTweakerAPI.logError("Could not get item with name: <item:" + tokens + ">! Syntax is <item:modid:itemname>", new Object[0]);
            return false;
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        if (((ForgeRegistry)ForgeRegistries.ITEMS).isLocked() && !ForgeRegistries.ITEMS.containsKey(key)) {
            CraftTweakerAPI.logError("Could not get item with name: <item:" + tokens + ">! Item does not appear to exist!", new Object[0]);
            return false;
        }
        return true;
    }
}

