/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.entity.IModularEntity;
import xyz.brassgoggledcoders.transport.api.module.Module;
import xyz.brassgoggledcoders.transport.api.module.ModuleInstance;
import xyz.brassgoggledcoders.transport.api.module.ModuleSlot;
import xyz.brassgoggledcoders.transport.event.ClientEventHandler;

public class AddModuleCaseMessage {
    private final int entityId;
    private final Module<?> module;
    private final ModuleSlot moduleSlot;

    public AddModuleCaseMessage(IModularEntity modularEntity, ModuleInstance<?> moduleInstance, ModuleSlot moduleSlot) {
        this(modularEntity.getSelf().func_145782_y(), (Module<?>)((Object)moduleInstance.getModule()), moduleSlot);
    }

    public AddModuleCaseMessage(int entityId, Module<?> module, ModuleSlot moduleSlot) {
        this.entityId = entityId;
        this.module = module;
        this.moduleSlot = moduleSlot;
    }

    public static AddModuleCaseMessage decode(PacketBuffer packetBuffer) {
        return new AddModuleCaseMessage(packetBuffer.readInt(), Module.fromPacketBuffer(packetBuffer), TransportAPI.getModuleSlot(packetBuffer.func_192575_l()));
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.entityId);
        Module.toPacketBuffer(this.module, packetBuffer);
        packetBuffer.func_192572_a(Objects.requireNonNull(this.moduleSlot.getRegistryName()));
    }

    public void consume(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Entity entity = ClientEventHandler.getWorld().func_73045_a(this.entityId);
            if (entity != null && this.module != null && this.moduleSlot != null) {
                entity.getCapability(TransportAPI.MODULAR_ENTITY).ifPresent(modularEntity -> modularEntity.add(this.module, this.moduleSlot, false));
            }
        }));
        contextSupplier.get().setPacketHandled(true);
    }
}

