/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.rail.turnout;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import xyz.brassgoggledcoders.transport.block.rail.turnout.AbstractSwitchRailBlock;
import xyz.brassgoggledcoders.transport.block.rail.turnout.SwitchConfiguration;
import xyz.brassgoggledcoders.transport.content.TransportItemTags;

public class SwitchRailBlock
extends AbstractSwitchRailBlock {
    public static final EnumProperty<RailShape> DIVERGE_SHAPE = EnumProperty.func_177708_a((String)"diverge_shape", RailShape.class, railShape -> railShape == RailShape.NORTH_EAST || railShape == RailShape.SOUTH_EAST || railShape == RailShape.SOUTH_WEST || railShape == RailShape.NORTH_WEST);
    public static final EnumProperty<RailShape> STRAIGHT_SHAPE = EnumProperty.func_177708_a((String)"straight_shape", RailShape.class, railShape -> railShape == RailShape.NORTH_SOUTH || railShape == RailShape.EAST_WEST);

    public SwitchRailBlock() {
        this(Block.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.7f).func_200947_a(SoundType.field_185852_e));
    }

    public SwitchRailBlock(Block.Properties properties) {
        super(true, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.NORTH_SOUTH)).func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_EAST)).func_206870_a((IProperty)DIVERGE, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STRAIGHT_SHAPE, DIVERGE_SHAPE, DIVERGE});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockState = this.func_176223_P();
        Direction[] nearestDirections = context.func_196009_e();
        if (nearestDirections.length >= 3) {
            Direction secondClosest;
            Direction firstClosest;
            int currentCheck = 0;
            if ((firstClosest = nearestDirections[currentCheck++]).func_176740_k() == Direction.Axis.Y) {
                firstClosest = nearestDirections[currentCheck++];
            }
            if ((secondClosest = nearestDirections[currentCheck++]).func_176740_k() == Direction.Axis.Y) {
                secondClosest = nearestDirections[currentCheck];
            }
            if (firstClosest == Direction.NORTH) {
                blockState = (BlockState)blockState.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                blockState = secondClosest == Direction.EAST ? (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_EAST) : (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_WEST);
            } else if (firstClosest == Direction.SOUTH) {
                blockState = (BlockState)blockState.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                blockState = secondClosest == Direction.EAST ? (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.NORTH_EAST) : (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.NORTH_WEST);
            } else if (firstClosest == Direction.WEST) {
                blockState = (BlockState)blockState.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.EAST_WEST);
                blockState = secondClosest == Direction.NORTH ? (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.NORTH_EAST) : (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_EAST);
            } else if (firstClosest == Direction.EAST) {
                blockState = (BlockState)blockState.func_206870_a(STRAIGHT_SHAPE, (Comparable)RailShape.EAST_WEST);
                blockState = secondClosest == Direction.NORTH ? (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.NORTH_WEST) : (BlockState)blockState.func_206870_a(DIVERGE_SHAPE, (Comparable)RailShape.SOUTH_WEST);
            }
        }
        return blockState;
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (TransportItemTags.WRENCHES.func_199685_a_(player.func_184586_b(hand).func_77973_b())) {
            world.func_180501_a(pos, (BlockState)state.func_177231_a(DIVERGE_SHAPE), 3);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    @Nonnull
    public IProperty<RailShape> func_176560_l() {
        return STRAIGHT_SHAPE;
    }

    @Override
    protected RailShape getStraightShape(SwitchConfiguration switchConfiguration) {
        return switchConfiguration.getStraight();
    }

    @Override
    protected SwitchConfiguration getSwitchConfiguration(BlockState blockState) {
        return SwitchConfiguration.get((RailShape)blockState.func_177229_b(STRAIGHT_SHAPE), (RailShape)blockState.func_177229_b(DIVERGE_SHAPE));
    }

    @Override
    protected Direction getMotorDirection(SwitchConfiguration switchConfiguration) {
        return switchConfiguration.getDivergentSide().func_176734_d();
    }
}

