/*
 * Decompiled with CFR 0.152.
 */
package xyz.brassgoggledcoders.transport.block.rail.turnout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import xyz.brassgoggledcoders.transport.api.TransportAPI;
import xyz.brassgoggledcoders.transport.api.pointmachine.IPointMachineBehavior;
import xyz.brassgoggledcoders.transport.block.rail.turnout.SwitchConfiguration;

public abstract class AbstractSwitchRailBlock
extends AbstractRailBlock {
    public static final BooleanProperty DIVERGE = BooleanProperty.func_177716_a((String)"diverge");

    protected AbstractSwitchRailBlock(boolean disableCorner, Block.Properties properties) {
        super(disableCorner, properties);
    }

    protected boolean shouldDivert(IBlockReader blockReader, BlockPos motorLocation, BlockPos switchLocation, @Nullable AbstractMinecartEntity cart) {
        BlockState motorState = blockReader.func_180495_p(motorLocation);
        IPointMachineBehavior motorBehavior = TransportAPI.getPointMachineBehavior(motorState.func_177230_c());
        if (motorBehavior != null) {
            Entity leader = TransportAPI.getConnectionChecker().getLeader((Entity)cart);
            if (leader instanceof AbstractMinecartEntity) {
                return motorBehavior.shouldDiverge(motorState, blockReader, motorLocation, switchLocation, (AbstractMinecartEntity)leader);
            }
            return motorBehavior.shouldDiverge(motorState, blockReader, motorLocation, switchLocation, cart);
        }
        return false;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        BlockPos motorPos;
        BlockState motorState;
        IPointMachineBehavior motorBehavior;
        SwitchConfiguration configuration = this.getSwitchConfiguration(state);
        if (this.getMotorDirection(configuration) == facing && (motorBehavior = TransportAPI.getPointMachineBehavior((motorState = world.func_180495_p(motorPos = currentPos.func_177972_a(facing))).func_177230_c())) != null) {
            motorBehavior.onBlockStateUpdate(motorState, (IBlockReader)world, motorPos);
            state = (BlockState)state.func_206870_a((IProperty)DIVERGE, (Comparable)Boolean.valueOf(motorBehavior.shouldDiverge(motorState, (IBlockReader)world, motorPos, currentPos, null)));
        }
        return state;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public RailShape getRailDirection(BlockState state, IBlockReader blockReader, BlockPos pos, @Nullable AbstractMinecartEntity minecartEntity) {
        SwitchConfiguration switchConfiguration = this.getSwitchConfiguration(state);
        RailShape straightShape = this.getStraightShape(switchConfiguration);
        RailShape divergeShape = this.getDivergeShape(switchConfiguration);
        if (minecartEntity != null) {
            Direction entrance = minecartEntity.func_184172_bi().func_176734_d();
            if (entrance == switchConfiguration.getNarrowSide()) {
                if (this.shouldDivert(blockReader, pos.func_177972_a(this.getMotorDirection(switchConfiguration)), pos, minecartEntity)) {
                    return switchConfiguration.getDiverge();
                }
                return straightShape;
            }
            if (entrance == switchConfiguration.getDivergentSide()) {
                return divergeShape;
            }
            return straightShape;
        }
        return this.shouldDivert(blockReader, pos.func_177972_a(this.getMotorDirection(switchConfiguration)), pos, null) ? divergeShape : straightShape;
    }

    public boolean canMakeSlopes(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    protected RailShape getDivergeShape(SwitchConfiguration switchConfiguration) {
        return switchConfiguration.getDiverge();
    }

    protected abstract RailShape getStraightShape(SwitchConfiguration var1);

    protected abstract SwitchConfiguration getSwitchConfiguration(BlockState var1);

    protected abstract Direction getMotorDirection(SwitchConfiguration var1);
}

