/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.forge.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.forge.clothconfig2.gui.entries.TextFieldListEntry;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FloatListEntry
extends TextFieldListEntry<Float> {
    private static Function<String, String> stripCharacters = s -> {
        StringBuilder stringBuilder_1 = new StringBuilder();
        char[] var2 = s.toCharArray();
        int var3 = var2.length;
        for (char c : var2) {
            if (!Character.isDigit(c) && c != '-' && c != '.') continue;
            stringBuilder_1.append(c);
        }
        return stringBuilder_1.toString();
    };
    private float minimum = -3.4028235E38f;
    private float maximum = Float.MAX_VALUE;
    private Consumer<Float> saveConsumer;

    @Deprecated
    public FloatListEntry(String fieldName, Float value, Consumer<Float> saveConsumer) {
        this(fieldName, value, "text.cloth-config.reset_value", null, saveConsumer);
    }

    @Deprecated
    public FloatListEntry(String fieldName, Float value, String resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    public FloatListEntry(String fieldName, Float value, String resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    public FloatListEntry(String fieldName, Float value, String resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }

    @Override
    protected void textFieldPreRender(TextFieldWidget widget) {
        try {
            double i = Float.parseFloat(this.textFieldWidget.func_146179_b());
            if (i < (double)this.minimum || i > (double)this.maximum) {
                widget.func_146193_g(0xFF5555);
            } else {
                widget.func_146193_g(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.func_146193_g(0xFF5555);
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() && text.equals(((Float)this.defaultValue.get()).toString());
    }

    public FloatListEntry setMinimum(float minimum) {
        this.minimum = minimum;
        return this;
    }

    public FloatListEntry setMaximum(float maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public Float getValue() {
        try {
            return Float.valueOf(this.textFieldWidget.func_146179_b());
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public Optional<String> getError() {
        try {
            float i = Float.parseFloat(this.textFieldWidget.func_146179_b());
            if (i > this.maximum) {
                return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_large", (Object[])new Object[]{Float.valueOf(this.maximum)}));
            }
            if (i < this.minimum) {
                return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.too_small", (Object[])new Object[]{Float.valueOf(this.minimum)}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(I18n.func_135052_a((String)"text.cloth-config.error.not_valid_number_float", (Object[])new Object[0]));
        }
        return super.getError();
    }
}

