/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.test;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yogpc.qp.machines.workbench.EnchantmentCopyRecipe;
import com.yogpc.qp.machines.workbench.IngredientWithCount;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes$;
import com.yogpc.qp.machines.workbench.WorkbenchRecipes$Serializer$;
import com.yogpc.qp.utils.Holder$;
import java.io.Serializable;
import java.util.Arrays;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.javaapi.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005i3Q!\u0003\u0006\u0001\u0015IAQ!\u0007\u0001\u0005\u0002mAaA\b\u0001!\n\u001by\u0002bB\u001c\u0001\u0005\u0004%\t\u0001\u000f\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001d\t\u000b\t\u0003A\u0011A\"\t\u000bQ\u0003A\u0011A\"\t\u000bY\u0003A\u0011A\"\t\u000ba\u0003A\u0011A\"\u0003\u0015I+7-\u001b9f)\u0016\u001cHO\u0003\u0002\f\u0019\u0005!A/Z:u\u0015\tia\"\u0001\u0002ra*\u0011q\u0002E\u0001\u0006s><\u0007o\u0019\u0006\u0002#\u0005\u00191m\\7\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005a\u0002CA\u000f\u0001\u001b\u0005Q\u0011AA5e)\t\u0001#\u0006\u0005\u0002\"Q5\t!E\u0003\u0002$I\u0005!Q\u000f^5m\u0015\t)c%A\u0005nS:,7M]1gi*\tq%A\u0002oKRL!!\u000b\u0012\u0003!I+7o\\;sG\u0016dunY1uS>t\u0007\"B\u0016\u0003\u0001\u0004a\u0013!A:\u0011\u00055\"dB\u0001\u00183!\tyS#D\u00011\u0015\t\t$$\u0001\u0004=e>|GOP\u0005\u0003gU\ta\u0001\u0015:fI\u00164\u0017BA\u001b7\u0005\u0019\u0019FO]5oO*\u00111'F\u0001\u0005UN|g.F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0003hg>t'B\u0001 \u0011\u0003\u00199wn\\4mK&\u0011\u0001i\u000f\u0002\u000b\u0015N|gn\u00142kK\u000e$\u0018!\u00026t_:\u0004\u0013!D2p]Z,'\u000f\u001e*fG&\u0004X\rF\u0001E!\t!R)\u0003\u0002G+\t!QK\\5uQ\t)\u0001\n\u0005\u0002J%6\t!J\u0003\u0002L\u0019\u0006\u0019\u0011\r]5\u000b\u00055s\u0015a\u00026va&$XM\u001d\u0006\u0003\u001fB\u000bQA[;oSRT\u0011!U\u0001\u0004_J<\u0017BA*K\u0005\u0011!Vm\u001d;\u0002'\r|\u0007/_#oG\"\fg\u000e^7f]R$Vm\u001d;)\u0005\u0019A\u0015aC2paft%\r\u001e+fgRD#a\u0002%\u0002)\u001d|G/\u0012:s_J4%o\\7O_J+7/\u001e7uQ\tA\u0001\n")
public class RecipeTest {
    private final JsonObject json = JSONUtils.func_212745_a((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |{\n      |  \"type\": \"quarryplus:workbench_recipe\",\n      |  \"id\": \"quarryplus:convert_quarry\",\n      |  \"sub_type\": \"copy_enchantment\",\n      |  \"enchantment_from\": {\n      |    \"item\": \"quarryplus:quarryplus\",\n      |    \"count\": 1\n      |  },\n      |  \"ingredients\": [ ],\n      |  \"energy\": 1000.0,\n      |  \"result\": {\n      |    \"item\": \"quarryplus:quarry\",\n      |    \"count\": 1\n      |  },\n      |  \"conditions\": [\n      |    {\n      |      \"value\": \"NewQuarry\",\n      |      \"type\": \"quarryplus:machine_enabled\"\n      |    },\n      |    {\n      |      \"value\": \"QuarryPlus\",\n      |      \"type\": \"quarryplus:machine_enabled\"\n      |    }\n      |  ]\n      |}")));

    private final ResourceLocation id(String s) {
        return new ResourceLocation("test", s);
    }

    public JsonObject json() {
        return this.json;
    }

    @Test
    public void convertRecipe() {
        WorkbenchRecipes recipes2 = WorkbenchRecipes$Serializer$.MODULE$.read(new ResourceLocation("quarryplus:convert_quarry"), this.json());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)new ResourceLocation("quarryplus:convert_quarry"), (Object)recipes2.func_199560_c()), () -> Assertions.assertTrue((boolean)recipes2.hasContent(), (String)"Valid recipe"), () -> Assertions.assertEquals((Object)Holder$.MODULE$.blockQuarry2().func_199767_j(), (Object)recipes2.getOutput().func_77973_b()), () -> Assertions.assertEquals((int)1, (int)recipes2.getOutput().func_190916_E()), () -> Assertions.assertEquals(EnchantmentCopyRecipe.class, recipes2.getClass(), (String)"Class check"), () -> Assertions.assertEquals((int)1, (int)((SeqOps)recipes2.inputs().head()).size())});
    }

    @Test
    public void copyEnchantmentTest() {
        WorkbenchRecipes recipes2 = WorkbenchRecipes$Serializer$.MODULE$.read(new ResourceLocation("quarryplus:convert_quarry"), this.json());
        ItemStack oldQuarry = new ItemStack((IItemProvider)Holder$.MODULE$.blockQuarry());
        EnchantmentHelper.func_82782_a((java.util.Map)CollectionConverters$.MODULE$.asJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Enchantments.field_185306_r), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Enchantments.field_185305_q), (Object)BoxesRunTime.boxToInteger((int)4))}))), (ItemStack)oldQuarry);
        ItemStack out = recipes2.getOutput(Arrays.asList((Object[])new ItemStack[]{oldQuarry}));
        Assertions.assertFalse((boolean)out.func_190926_b(), (String)"Out is valid item.");
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((int)1, (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)out), (String)"Silktouch"), () -> Assertions.assertEquals((int)4, (int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)out), (String)"Efficiency")});
    }

    @Test
    public void copyNbtTest() {
        ItemStack recipeOut = new ItemStack((IItemProvider)Items.field_151034_e);
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("test1", "a");
        recipeOut.func_77982_d(tag);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        EnchantmentCopyRecipe recipe = new EnchantmentCopyRecipe(this.id("d"), recipeOut, 100L, (Seq<IngredientWithCount>)((Seq)new .colon.colon((Object)new IngredientWithCount(new ItemStack((IItemProvider)Items.field_221554_G, 4)), (List)Nil$.MODULE$)), (Seq<Seq<IngredientWithCount>>)Nil$.MODULE$);
        java.util.List<Object> ins = Arrays.asList((Object[])new ItemStack[]{new ItemStack((IItemProvider)Items.field_221554_G, 2), new ItemStack((IItemProvider)Items.field_221554_G, 7)});
        ItemStack o = recipe.getOutput(ins);
        Assertions.assertTrue((boolean)ItemStack.func_77989_b((ItemStack)recipeOut, (ItemStack)o));
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        ItemStack in1 = new ItemStack((IItemProvider)Items.field_221554_G, 2);
        in1.func_77966_a(Enchantments.field_185305_q, 3);
        ItemStack in2 = new ItemStack((IItemProvider)Items.field_221554_G, 7);
        CompoundNBT t = new CompoundNBT();
        t.func_74774_a("test2", (byte)4);
        in2.func_77982_d(t);
        java.util.List<Object> ins2 = Arrays.asList((Object[])new ItemStack[]{in1, in2});
        ItemStack o2 = recipe.getOutput(ins2);
        CompoundNBT tag2 = o2.func_77978_p();
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertEquals((Object)"a", (Object)tag2.func_74779_i("test1")), () -> Assertions.assertEquals((int)4, (int)tag2.func_74771_c("test2"))});
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    @Test
    public void gotErrorFromNoResult() {
        JsonObject noResult = JSONUtils.func_212745_a((String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |{\n        |  \"type\": \"quarryplus:workbench_recipe\",\n        |  \"ingredients\": [\n        |    {\n        |      \"tag\": \"forge:ingots/gold\",\n        |      \"count\": 16\n        |    }\n        |  ],\n        |  \"energy\": 320000.0,\n        |  \"showInJEI\": true\n        |}\n        |")));
        Either<String, WorkbenchRecipes> noResultRecipe = WorkbenchRecipes$.MODULE$.parse(noResult, this.id("no_result"));
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertTrue((boolean)noResultRecipe.isLeft(), (String)"no result"), () -> Assertions.assertTrue((boolean)noResultRecipe.left().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("JsonSyntaxException"))))});
        JsonObject hasEmptyResult = new JsonObject();
        noResult.entrySet().forEach(e -> hasEmptyResult.add((String)e.getKey(), (JsonElement)e.getValue()));
        hasEmptyResult.add("result", (JsonElement)new JsonObject());
        Either<String, WorkbenchRecipes> resultRecipe = WorkbenchRecipes$.MODULE$.parse(hasEmptyResult, this.id("empty_result"));
        Assertions.assertTrue((boolean)resultRecipe.isLeft(), (String)"empty result");
    }
}

