/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.mover;

import com.yogpc.qp.machines.quarry.TileBasic;
import com.yogpc.qp.machines.workbench.BlockData;
import com.yogpc.qp.packet.IMessage;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentMessage
implements IMessage<EnchantmentMessage> {
    Type type;
    BlockPos pos;
    int dim;
    Enchantment enchantment;
    BlockData data;

    public static EnchantmentMessage create(TileBasic tile, Type type, Enchantment enchantment, BlockData data) {
        EnchantmentMessage message = new EnchantmentMessage();
        message.pos = tile.func_174877_v();
        message.dim = IMessage.getDimId(tile.func_145831_w());
        message.type = type;
        message.enchantment = enchantment;
        message.data = data;
        return message;
    }

    @Override
    public EnchantmentMessage readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.type = (Type)buffer.func_179257_a(Type.class);
        this.enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.func_192575_l());
        this.data = BlockData.read(buffer.func_150793_b());
        this.dim = buffer.readInt();
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).func_179249_a((Enum)this.type).func_192572_a(Objects.requireNonNull(this.enchantment.getRegistryName())).func_150786_a((CompoundNBT)BlockData.dataToNbt().apply((Object)this.data)).writeInt(this.dim);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        IMessage.findTile(ctx, this.pos, this.dim, TileBasic.class).ifPresent(tile -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
            if (this.type == Type.Toggle) {
                if (this.enchantment == Enchantments.field_185308_t) {
                    tile.fortuneInclude = !tile.fortuneInclude;
                } else if (this.enchantment == Enchantments.field_185306_r) {
                    tile.silktouchInclude = !tile.silktouchInclude;
                }
            } else if (this.type == Type.Remove) {
                if (this.enchantment == Enchantments.field_185308_t) {
                    tile.fortuneList.remove(this.data);
                } else if (this.enchantment == Enchantments.field_185306_r) {
                    tile.silktouchList.remove(this.data);
                }
            }
        }));
    }

    public static enum Type {
        Toggle,
        Remove;

    }
}

