/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet.advquarry;

import com.yogpc.qp.machines.advquarry.AdvQuarryWork;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.base.Area;
import com.yogpc.qp.packet.IMessage;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import scala.Function1;

public class AdvModeMessage
implements IMessage<AdvModeMessage> {
    int dim;
    BlockPos pos;
    CompoundNBT modeNBT;

    public static AdvModeMessage create(TileAdvQuarry quarry) {
        AdvModeMessage message = new AdvModeMessage();
        message.dim = IMessage.getDimId(quarry.func_145831_w());
        message.pos = quarry.func_174877_v();
        AdvQuarryWork mode = quarry.action();
        Area digRange = quarry.getArea();
        CompoundNBT nbt = new CompoundNBT();
        CompoundNBT areaNbt = (CompoundNBT)Area.areaToNbt().apply((Object)digRange);
        nbt.func_218657_a("area", (INBT)areaNbt);
        CompoundNBT modeNbt = mode.serverWrite(new CompoundNBT());
        nbt.func_218657_a("mode", (INBT)modeNbt);
        message.modeNBT = nbt;
        return message;
    }

    @Override
    public AdvModeMessage readFromBuffer(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.dim = buffer.readInt();
        this.modeNBT = buffer.func_150793_b();
        return this;
    }

    @Override
    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos).writeInt(this.dim);
        buffer.func_150786_a(this.modeNBT);
    }

    @Override
    public void onReceive(Supplier<NetworkEvent.Context> ctx) {
        IMessage.findTile(ctx, this.pos, this.dim, TileAdvQuarry.class).ifPresent(quarry -> ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
            quarry.setArea(Area.areaLoad(this.modeNBT.func_74775_l("area")));
            quarry.action_$eq((AdvQuarryWork)((Function1)AdvQuarryWork.load().apply(quarry)).apply((Object)this.modeNBT.func_74775_l("mode")));
        }));
    }
}

