/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.pump;

import com.yogpc.qp.machines.base.HasStorage;
import com.yogpc.qp.machines.base.IDummyFluidHandler;
import com.yogpc.qp.utils.FluidElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TankPump
implements HasStorage.Storage,
ICapabilityProvider {
    All all = new All();
    Map<FluidElement, FluidStack> stacks = new HashMap<FluidElement, FluidStack>();
    List<FluidElement> keys = new ArrayList<FluidElement>();
    public EnumMap<Direction, List<FluidElement>> mapping = new EnumMap(Direction.class);
    EnumMap<Direction, PumpTank> pumpTankEnumMap = new EnumMap(Direction.class);

    public TankPump() {
        for (Direction direction : Direction.values()) {
            this.mapping.put(direction, new ArrayList());
            this.pumpTankEnumMap.put(direction, new PumpTank(direction));
        }
    }

    @Override
    public void insertItem(ItemStack stack) {
    }

    @Override
    public void insertFluid(FluidStack fluidStack) {
        FluidElement key = FluidElement.fromStack(fluidStack);
        this.stacks.merge(key, fluidStack, (fluidStack1, fluidStack2) -> {
            FluidStack newOne = fluidStack1.copy();
            newOne.setAmount(newOne.getAmount() + fluidStack2.getAmount());
            return newOne;
        });
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            All handler = side == null ? this.all : (IFluidHandler)this.pumpTankEnumMap.get(side);
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> handler));
        }
        return LazyOptional.empty();
    }

    public Collection<FluidStack> getAllContents() {
        return Collections.unmodifiableCollection(this.stacks.values());
    }

    public CompoundNBT serializeNBT(boolean writeContents) {
        CompoundNBT allNbt = new CompoundNBT();
        CompoundNBT mappingNbt = new CompoundNBT();
        this.mapping.forEach((direction, fluidStacks) -> {
            ListNBT fss = fluidStacks.stream().map(FluidElement::toCompoundTag).collect(Collectors.toCollection(ListNBT::new));
            mappingNbt.func_218657_a(direction.func_176610_l(), (INBT)fss);
        });
        if (writeContents) {
            ListNBT keysNbt = this.keys.stream().map(FluidElement::toCompoundTag).collect(Collectors.toCollection(ListNBT::new));
            ListNBT stacksNbt = this.stacks.values().stream().map(fs -> fs.writeToNBT(new CompoundNBT())).collect(Collectors.toCollection(ListNBT::new));
            allNbt.func_218657_a("keys", (INBT)keysNbt);
            allNbt.func_218657_a("stacks", (INBT)stacksNbt);
        }
        allNbt.func_218657_a("mapping", (INBT)mappingNbt);
        return allNbt;
    }

    public void deserializeNBT(CompoundNBT allNbt, boolean readContents) {
        CompoundNBT mappingNbt = allNbt.func_74775_l("mapping");
        for (Direction direction : Direction.values()) {
            ListNBT fss = mappingNbt.func_150295_c(direction.func_176610_l(), 10);
            this.mapping.put(direction, fss.stream().map(CompoundNBT.class::cast).map(FluidElement::fromNBT).collect(Collectors.toList()));
        }
        if (readContents) {
            ListNBT keysNbt = allNbt.func_150295_c("keys", 10);
            ListNBT stacksNbt = allNbt.func_150295_c("stacks", 10);
            this.keys = keysNbt.stream().map(CompoundNBT.class::cast).map(FluidElement::fromNBT).collect(Collectors.toList());
            this.stacks.clear();
            stacksNbt.stream().map(CompoundNBT.class::cast).map(FluidStack::loadFluidStackFromNBT).filter(s -> this.keys.contains(FluidElement.fromStack(s))).forEach(s -> this.stacks.put(FluidElement.fromStack(s), (FluidStack)s));
        }
    }

    private class PumpTank
    implements IFluidHandler {
        final Direction facing;

        private PumpTank(Direction facing) {
            this.facing = facing;
        }

        private List<FluidElement> getList() {
            return TankPump.this.mapping.get(this.facing);
        }

        public int getTanks() {
            return this.getList().size();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return TankPump.this.stacks.get(this.getList().get(tank));
        }

        public int getTankCapacity(int tank) {
            return Integer.MAX_VALUE;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidElement key = FluidElement.fromStack(resource);
            if (resource.isEmpty() || !TankPump.this.stacks.containsKey(key)) {
                return FluidStack.EMPTY;
            }
            FluidStack source = TankPump.this.stacks.get(key);
            if (source.getAmount() > resource.getAmount()) {
                if (action.execute()) {
                    TankPump.this.stacks.put(key, new FluidStack(source, source.getAmount() - resource.getAmount()));
                }
                return resource.copy();
            }
            if (action.execute()) {
                TankPump.this.stacks.remove(key);
                TankPump.this.keys.remove(key);
            }
            return source.copy();
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain <= 0 || TankPump.this.stacks.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack source = this.getList().isEmpty() ? TankPump.this.stacks.get(TankPump.this.keys.get(0)) : TankPump.this.stacks.get(this.getList().get(0));
            FluidStack resource = new FluidStack(source, maxDrain);
            return this.drain(resource, action);
        }
    }

    private class All
    implements IDummyFluidHandler {
        private All() {
        }

        public int getTanks() {
            return TankPump.this.stacks.size();
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return TankPump.this.stacks.get(TankPump.this.keys.get(tank));
        }

        public int getTankCapacity(int tank) {
            return this.getFluidInTank(tank).getAmount();
        }
    }
}

