/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.routing;

import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Endpoint {
    public final BlockPos pos;
    public final Direction face;

    public Endpoint(BlockPos tePos, Direction blockFace) {
        this.pos = tePos;
        this.face = blockFace;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Endpoint) {
            Endpoint otherEndpoint = (Endpoint)other;
            return this.pos.equals((Object)otherEndpoint.pos) && this.face.equals((Object)otherEndpoint.face);
        }
        return false;
    }

    public boolean canInsertItem(World world, ItemStack stack) {
        TileEntity te = world.func_175625_s(this.pos);
        if (te == null) {
            return false;
        }
        LazyOptional optionalHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.face);
        return (Boolean)optionalHandler.map(handler -> Endpoint.canInsertItem(handler, stack)).orElse((Object)false);
    }

    public static boolean canInsertItem(IItemHandler handler, ItemStack stack) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.isItemValid(i, stack) || handler.insertItem(i, stack, true).func_190916_E() >= stack.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode() ^ this.face.hashCode();
    }

    public String toString() {
        return this.pos + ";    " + this.face;
    }

    public int getFirstValidSlot(ItemStack stack, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.isItemValid(i, stack)) continue;
            return i;
        }
        return -1;
    }
}

