/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.blocks.tube;

import com.github.commoble.tubesreloaded.common.TubesReloadedMod;
import com.github.commoble.tubesreloaded.common.blocks.tube.ItemInTubeWrapper;
import com.github.commoble.tubesreloaded.common.blocks.tube.TubeBlock;
import com.github.commoble.tubesreloaded.common.blocks.tube.TubeInventoryHandler;
import com.github.commoble.tubesreloaded.common.registry.TileEntityRegistrar;
import com.github.commoble.tubesreloaded.common.routing.Route;
import com.github.commoble.tubesreloaded.common.routing.RoutingNetwork;
import com.github.commoble.tubesreloaded.common.util.WorldHelper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TubeTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final String INV_NBT_KEY_ADD = "inventory_new_items";
    public static final String INV_NBT_KEY_RESET = "inventory_reset";
    @Nonnull
    public Queue<ItemInTubeWrapper> inventory = new LinkedList<ItemInTubeWrapper>();
    protected final TubeInventoryHandler[] inventoryHandlers = (TubeInventoryHandler[])Arrays.stream(Direction.values()).map(dir -> new TubeInventoryHandler(this, (Direction)dir)).toArray(TubeInventoryHandler[]::new);
    protected final LazyOptional<IItemHandler>[] handlerOptionals = (LazyOptional[])Arrays.stream(this.inventoryHandlers).map(handler -> LazyOptional.of(() -> handler)).toArray(LazyOptional[]::new);
    private Queue<ItemInTubeWrapper> wrappers_to_send_to_client = new LinkedList<ItemInTubeWrapper>();
    public Queue<ItemInTubeWrapper> incoming_wrapper_buffer = new LinkedList<ItemInTubeWrapper>();
    @Nonnull
    private RoutingNetwork network = RoutingNetwork.INVALID_NETWORK;

    public TubeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TubeTileEntity() {
        this(TileEntityRegistrar.TUBE);
    }

    public RoutingNetwork getNetwork() {
        if (this.network.invalid) {
            this.network = RoutingNetwork.buildNetworkFrom(this.field_174879_c, this.field_145850_b);
        }
        return this.network;
    }

    public void setNetwork(RoutingNetwork network) {
        this.network = network;
    }

    public boolean isTubeCompatible(TubeTileEntity tube) {
        Block thisBlock = this.func_195044_w().func_177230_c();
        Block otherBlock = tube.func_195044_w().func_177230_c();
        if (thisBlock instanceof TubeBlock && otherBlock instanceof TubeBlock) {
            return ((TubeBlock)thisBlock).isTubeCompatible((TubeBlock)otherBlock);
        }
        return false;
    }

    public List<Direction> getConnectedDirections() {
        BlockState state = this.func_195044_w();
        return TubeBlock.getConnectedDirections(state);
    }

    public static Optional<TubeTileEntity> getTubeTEAt(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return Optional.ofNullable(te instanceof TubeTileEntity ? (TubeTileEntity)te : null);
    }

    public Route getBestRoute(Direction insertionSide, ItemStack stack) {
        return this.getNetwork().getBestRoute(this.field_145850_b, this.field_174879_c, insertionSide, stack);
    }

    public void func_145843_s() {
        this.dropItems();
        this.network.invalid = true;
        Arrays.stream(this.handlerOptionals).forEach(optional -> optional.invalidate());
        super.func_145843_s();
    }

    public void onPossibleNetworkUpdateRequired() {
        if (!this.network.invalid && this.didNetworkChange()) {
            this.network.invalid = true;
        }
    }

    private boolean didNetworkChange() {
        for (Direction face : Direction.values()) {
            BlockPos checkPos = this.field_174879_c.func_177972_a(face);
            if (this.getNetwork().contains(this.field_174879_c, face.func_176734_d()) == this.getNetwork().isValidToBeInNetwork(checkPos, this.field_145850_b, face.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        this.merge_buffer();
        if (!this.inventory.isEmpty()) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
            }
            LinkedList<ItemInTubeWrapper> remainingWrappers = new LinkedList<ItemInTubeWrapper>();
            for (ItemInTubeWrapper wrapper : this.inventory) {
                ++wrapper.ticksElapsed;
                if (wrapper.ticksElapsed >= wrapper.maximumDurationInTube) {
                    if (wrapper.freshlyInserted) {
                        wrapper.freshlyInserted = false;
                        wrapper.remainingMoves.removeFirst();
                        wrapper.ticksElapsed = 0;
                        remainingWrappers.add(wrapper);
                        continue;
                    }
                    this.sendWrapperOnward(wrapper);
                    continue;
                }
                remainingWrappers.add(wrapper);
            }
            this.inventory = remainingWrappers;
        }
        if (!this.field_145850_b.field_72995_K && this.inventory.size() > TubesReloadedMod.config.max_items_in_tube.get()) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public void sendWrapperOnward(ItemInTubeWrapper wrapper) {
        if (!wrapper.remainingMoves.isEmpty()) {
            Direction dir = wrapper.remainingMoves.poll();
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (te instanceof TubeTileEntity && this.isTubeCompatible((TubeTileEntity)te)) {
                ((TubeTileEntity)te).enqueueItemStack(wrapper.stack, wrapper.remainingMoves, wrapper.maximumDurationInTube);
            } else if (!this.field_145850_b.field_72995_K) {
                if (te != null) {
                    ItemStack remaining = (ItemStack)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).map(handler -> WorldHelper.disperseItemToHandler(wrapper.stack, handler)).orElse((Object)wrapper.stack.func_77946_l());
                    if (!remaining.func_190926_b()) {
                        ItemStack unenqueueableItems = this.enqueueItemStack(remaining, dir, false);
                        WorldHelper.ejectItemstack(this.field_145850_b, this.field_174879_c, dir, unenqueueableItems);
                    }
                } else {
                    WorldHelper.ejectItemstack(this.field_145850_b, this.field_174879_c, dir, wrapper.stack);
                }
            }
        } else if (!this.field_145850_b.field_72995_K) {
            WorldHelper.ejectItemstack(this.field_145850_b, this.field_174879_c, null, wrapper.stack);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null) {
            return this.handlerOptionals[side.func_176745_a()].cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack enqueueItemStack(ItemStack stack, Direction face, boolean simulate) {
        Route route = this.getNetwork().getBestRoute(this.field_145850_b, this.field_174879_c, face, stack);
        if (route == null || route.sequenceOfMoves.isEmpty()) {
            return stack.func_77946_l();
        }
        if (simulate) {
            return ItemStack.field_190927_a;
        }
        int ticks_per_tube = this.getNetwork().getTicksPerTube();
        this.wrappers_to_send_to_client.add(new ItemInTubeWrapper(stack, route.sequenceOfMoves, ticks_per_tube, face.func_176734_d()));
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        return this.enqueueItemStack(new ItemInTubeWrapper(stack, route.sequenceOfMoves, 10, face.func_176734_d()));
    }

    public ItemStack enqueueItemStack(ItemInTubeWrapper wrapper) {
        this.incoming_wrapper_buffer.add(wrapper);
        return ItemStack.field_190927_a;
    }

    public ItemStack enqueueItemStack(ItemStack stack, Queue<Direction> remainingMoves, int ticksPerTube) {
        return this.enqueueItemStack(new ItemInTubeWrapper(stack, remainingMoves, ticksPerTube));
    }

    public void merge_buffer() {
        if (!this.incoming_wrapper_buffer.isEmpty()) {
            for (ItemInTubeWrapper wrapper : this.incoming_wrapper_buffer) {
                this.inventory.add(wrapper);
            }
            this.incoming_wrapper_buffer = new LinkedList<ItemInTubeWrapper>();
        }
    }

    public void dropItems() {
        this.merge_buffer();
        for (ItemInTubeWrapper wrapper : this.inventory) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)wrapper.stack);
        }
        this.inventory = new LinkedList<ItemInTubeWrapper>();
    }

    public static boolean isSpaceForAnythingInItemHandler(IItemHandler handler) {
        return true;
    }

    public boolean isAnyInventoryAdjacent() {
        for (Direction face : Direction.values()) {
            LazyOptional cap;
            IItemHandler handler;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
            if (te == null || te instanceof TubeTileEntity || (handler = (IItemHandler)(cap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())).orElse(null)) == null || !TubeTileEntity.isSpaceForAnythingInItemHandler(handler)) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(INV_NBT_KEY_RESET)) {
            ListNBT invList = compound.func_150295_c(INV_NBT_KEY_RESET, 10);
            LinkedList<ItemInTubeWrapper> inventory = new LinkedList<ItemInTubeWrapper>();
            for (int i = 0; i < invList.size(); ++i) {
                CompoundNBT itemTag = invList.func_150305_b(i);
                inventory.add(ItemInTubeWrapper.readFromNBT(itemTag));
            }
            this.inventory = inventory;
        } else if (compound.func_74764_b(INV_NBT_KEY_ADD)) {
            ListNBT invList = compound.func_150295_c(INV_NBT_KEY_ADD, 10);
            for (int i = 0; i < invList.size(); ++i) {
                CompoundNBT itemTag = invList.func_150305_b(i);
                this.inventory.add(ItemInTubeWrapper.readFromNBT(itemTag));
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT invList = new ListNBT();
        this.merge_buffer();
        for (ItemInTubeWrapper wrapper : this.inventory) {
            CompoundNBT invTag = new CompoundNBT();
            wrapper.writeToNBT(invTag);
            invList.add((Object)invTag);
        }
        if (!invList.isEmpty()) {
            compound.func_218657_a(INV_NBT_KEY_RESET, (INBT)invList);
        }
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        super.func_189515_b(nbt);
        ListNBT invList = new ListNBT();
        while (!this.wrappers_to_send_to_client.isEmpty()) {
            ItemInTubeWrapper wrapper = this.wrappers_to_send_to_client.poll();
            CompoundNBT invTag = new CompoundNBT();
            wrapper.writeToNBT(invTag);
            invList.add((Object)invTag);
        }
        if (!invList.isEmpty()) {
            nbt.func_218657_a(INV_NBT_KEY_ADD, (INBT)invList);
        }
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

