/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public abstract class WootContainerScreen<T extends Container>
extends ContainerScreen<T> {
    public WootContainerScreen(T container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
    }

    public void renderEnergyBar(int x1, int y1, int height, int width, int curr, int max) {
        int filled = curr * 100 / max;
        filled = MathHelper.func_76125_a((int)filled, (int)0, (int)100);
        int h = filled * height / 100;
        WootContainerScreen.fill((int)(this.field_147003_i + x1), (int)(this.field_147009_r + y1 - h + 1), (int)(this.field_147003_i + x1 + width), (int)(this.field_147009_r + y1 + 1), (int)-65536);
    }

    public void renderFluidTank(int x1, int y1, int height, int width, int curr, int max, FluidStack fluidStack) {
        int filled = curr * 100 / max;
        filled = MathHelper.func_76125_a((int)filled, (int)0, (int)100);
        int h = filled * height / 100;
        this.drawFluid(this.field_147003_i + x1, this.field_147009_r + y1 - h + 1, fluidStack, width, h);
    }

    public void renderFluidTank(int x1, int y1, int height, int width, int max, FluidStack fluidStack) {
        int filled = fluidStack.getAmount() * 100 / max;
        filled = MathHelper.func_76125_a((int)filled, (int)0, (int)100);
        int h = filled * height / 100;
        this.drawFluid(this.field_147003_i + x1, this.field_147009_r + y1 - h + 1, fluidStack, width, h);
    }

    public void renderHorizontalBar(int x1, int y1, int x2, int y2, int curr, int max, int color) {
        int filled = curr * max / 100;
        filled = MathHelper.func_76125_a((int)filled, (int)0, (int)100);
        int l = filled * (x2 - x1) / 100;
        WootContainerScreen.fill((int)(this.field_147003_i + x1), (int)(this.field_147009_r + y2), (int)(this.field_147003_i + x2 + l), (int)(this.field_147009_r + y2), (int)color);
    }

    public void renderHorizontalGauge(int x1, int y1, int x2, int y2, int curr, int max, int color) {
        WootContainerScreen.fill((int)(this.field_147003_i + x1), (int)(this.field_147009_r + y1), (int)(this.field_147003_i + x2), (int)(this.field_147009_r + y2), (int)color);
        int p = curr * (x2 - x1) / max;
        for (int i = 0; i < p; ++i) {
            this.vLine(this.field_147003_i + x1 + 1 + i, this.field_147009_r + y1, this.field_147009_r + y2 - 1, i % 2 == 0 ? color : -16777216);
        }
    }

    public void renderFluidTankTooltip(int mouseX, int mouseY, FluidStack fluidStack, int capacity) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (!fluidStack.isEmpty()) {
            tooltip.add(fluidStack.getDisplayName().func_150254_d());
            tooltip.add(String.format("%d/%d mb", fluidStack.getAmount(), capacity));
        } else {
            tooltip.add(String.format("0/%d mb", capacity));
        }
        this.renderTooltip(tooltip, mouseX, mouseY);
    }

    public void renderEnergyTooltip(int mouseX, int mouseY, int curr, int capacity, int rate) {
        List<String> tooltip = Arrays.asList(String.format("%d/%d RF", curr, capacity), String.format("%d RF/tick", rate));
        this.renderTooltip(tooltip, mouseX, mouseY);
    }

    public void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        this.setGLColorFromInt(color);
        ResourceLocation resourceLocation = fluid.getFluid().getAttributes().getStillTexture();
        TextureAtlasSprite textureAtlasSprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(resourceLocation);
        this.drawTiledTexture(x, y, textureAtlasSprite, width, height);
    }

    private void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_227702_d_((float)red, (float)green, (float)blue, (float)alpha);
    }

    private void drawTiledTexture(int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                this.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        float minU = icon.func_94209_e();
        float maxU = icon.func_94212_f();
        float minV = icon.func_94206_g();
        float maxV = icon.func_94210_h();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), (double)this.itemRenderer.field_77023_b).func_225583_a_(minU, minV + (maxV - minV) * (float)height / 16.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)this.itemRenderer.field_77023_b).func_225583_a_(minU + (maxU - minU) * (float)width / 16.0f, minV + (maxV - minV) * (float)height / 16.0f).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)this.itemRenderer.field_77023_b).func_225583_a_(minU + (maxU - minU) * (float)width / 16.0f, minV).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, (double)this.itemRenderer.field_77023_b).func_225583_a_(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

