/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.tartarus;

import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMobKey;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Cell {
    private BlockPos origin;
    private BlockPos spawnPos;
    private AxisAlignedBB axisAlignedBB;
    private FakeMobKey fakeMobKey;

    public Cell(BlockPos origin) {
        this.origin = origin;
        this.spawnPos = origin.func_177982_a(4, 4, 4);
        this.fakeMobKey = null;
        this.axisAlignedBB = null;
    }

    public boolean isOccupied() {
        return this.fakeMobKey != null;
    }

    public void free() {
        this.fakeMobKey = null;
    }

    @Nullable
    public FakeMobKey getOccupant() {
        return this.fakeMobKey;
    }

    public boolean setMob(@Nonnull FakeMobKey fakeMobKey) {
        if (this.isOccupied()) {
            return false;
        }
        this.fakeMobKey = fakeMobKey;
        if (this.axisAlignedBB == null) {
            this.axisAlignedBB = new AxisAlignedBB(this.spawnPos).func_186662_g(3.0);
        }
        return true;
    }

    @Nonnull
    public List<ItemStack> sweep(@Nonnull World world) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.isOccupied()) {
            for (ItemEntity itemEntity : world.func_175647_a(ItemEntity.class, this.axisAlignedBB, x -> x.func_70089_S())) {
                drops.add(itemEntity.func_92059_d().func_77946_l());
                itemEntity.lifespan = 0;
            }
        }
        return drops;
    }

    public void run(@Nonnull World world) {
        if (this.isOccupied()) {
            SpawnController.get().spawnKill(this.fakeMobKey, world, this.spawnPos);
        }
    }
}

