/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.policy;

import ipsis.woot.policy.InternalPolicy;
import ipsis.woot.policy.PolicyConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PolicyRegistry {
    public static final Logger LOGGER = LogManager.getLogger();
    private static PolicyRegistry INSTANCE = new PolicyRegistry();
    private A internalPolicy = new A();
    private A customPolicy = new A();

    public static PolicyRegistry get() {
        return INSTANCE;
    }

    public PolicyRegistry() {
        this.loadInternalConfig();
    }

    private void loadInternalConfig() {
        InternalPolicy.CAPTURED_MOD.forEach(s -> this.internalPolicy.addToCaptureMod((String)s));
        InternalPolicy.CAPTURED_ENTITY.forEach(s -> this.internalPolicy.addToCaptureEntity((String)s));
        InternalPolicy.LEARN_MOD.forEach(s -> this.internalPolicy.addToLearnMod((String)s));
        InternalPolicy.LEARN_ITEM.forEach(s -> this.internalPolicy.addToLearnItem((String)s));
        this.internalPolicy.addToLearnMod("cyberware");
    }

    public void loadFromConfig() {
        this.customPolicy.clear();
        ((List)PolicyConfiguration.CAPTURE_BLACKLIST_FULL_MOD.get()).forEach(s -> this.customPolicy.addToCaptureMod((String)s));
        ((List)PolicyConfiguration.CAPTURE_BLACKLIST_ENTITY.get()).forEach(s -> this.customPolicy.addToCaptureEntity((String)s));
        ((List)PolicyConfiguration.LEARN_BLACKLIST_FULL_MOD.get()).forEach(s -> this.customPolicy.addToLearnMod((String)s));
        ((List)PolicyConfiguration.LEARN_BLACKLIST_ITEM.get()).forEach(s -> this.customPolicy.addToLearnItem((String)s));
        ((List)PolicyConfiguration.GENERATE_BLACKLIST_FULL_MOD.get()).forEach(s -> this.customPolicy.addToGenerateMod((String)s));
        ((List)PolicyConfiguration.GENERATE_BLACKLIST_ITEM.get()).forEach(s -> this.customPolicy.addToGenerateItem((String)s));
    }

    public boolean canCaptureEntity(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        for (String s : this.internalPolicy.captureMod) {
            if (!rl.func_110624_b().equalsIgnoreCase(s)) continue;
            return false;
        }
        for (String s : this.internalPolicy.captureEntity) {
            if (!s.equalsIgnoreCase(rl.toString())) continue;
            return false;
        }
        for (String s : this.customPolicy.captureMod) {
            if (!rl.func_110624_b().equalsIgnoreCase(s)) continue;
            return false;
        }
        for (String s : this.customPolicy.captureEntity) {
            if (!s.equalsIgnoreCase(rl.toString())) continue;
            return false;
        }
        return true;
    }

    public boolean canGenerateItem(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        for (String s : this.customPolicy.generateMod) {
            if (!rl.func_110624_b().equalsIgnoreCase(s)) continue;
            return false;
        }
        for (String s : this.customPolicy.generateItem) {
            if (!s.equalsIgnoreCase(rl.toString())) continue;
            return false;
        }
        return true;
    }

    public boolean canLearnItem(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        for (String s : this.customPolicy.learnMod) {
            if (!rl.func_110624_b().equalsIgnoreCase(s)) continue;
            return false;
        }
        for (String s : this.customPolicy.learnItem) {
            if (!s.equalsIgnoreCase(rl.toString())) continue;
            return false;
        }
        return true;
    }

    public boolean canSimulate(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        for (String s : (List)PolicyConfiguration.CUSTOM_DROPS_ONLY.get()) {
            if (!s.equalsIgnoreCase(rl.toString())) continue;
            return false;
        }
        return true;
    }

    private class A {
        private List<String> captureMod = new ArrayList<String>();
        private List<String> captureEntity = new ArrayList<String>();
        private List<String> learnMod = new ArrayList<String>();
        private List<String> learnItem = new ArrayList<String>();
        private List<String> generateMod = new ArrayList<String>();
        private List<String> generateItem = new ArrayList<String>();

        private A() {
        }

        public void clear() {
            this.captureMod.clear();
            this.captureEntity.clear();
            this.learnMod.clear();
            this.learnItem.clear();
            this.generateMod.clear();
            this.generateItem.clear();
        }

        public void addToCaptureMod(String s) {
            LOGGER.info("Blacklisting capturing of all entities from {}", (Object)s);
            this.captureMod.add(s);
        }

        public void addToCaptureEntity(String s) {
            LOGGER.info("Blacklisting capturing of {}", (Object)s);
            this.captureEntity.add(s);
        }

        public void addToLearnMod(String s) {
            LOGGER.info("Blacklisting learning of all items from {}", (Object)s);
            this.learnMod.add(s);
        }

        public void addToLearnItem(String s) {
            LOGGER.info("Blacklisting learning of {}", (Object)s);
            this.learnItem.add(s);
        }

        public void addToGenerateMod(String s) {
            LOGGER.info("Blacklisting generating of all items from {}", (Object)s);
            this.learnMod.add(s);
        }

        public void addToGenerateItem(String s) {
            LOGGER.info("Blacklisting generating of {}", (Object)s);
            this.learnItem.add(s);
        }
    }
}

