/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.oracle.network;

import io.netty.buffer.ByteBuf;
import ipsis.woot.modules.oracle.blocks.OracleContainer;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.FakeMob;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SimulatedMobDropsSummaryReply {
    public List<SimulatedMobDropSummary> drops = new ArrayList<SimulatedMobDropSummary>();

    public static SimulatedMobDropsSummaryReply fromBytes(ByteBuf buf) {
        SimulatedMobDropsSummaryReply reply = new SimulatedMobDropsSummaryReply();
        int numDrops = buf.readInt();
        for (int i = 0; i < numDrops; ++i) {
            reply.drops.add(SimulatedMobDropSummary.readFromPacket(buf));
        }
        return reply;
    }

    public static SimulatedMobDropsSummaryReply fromMob(String entityKey) {
        SimulatedMobDropsSummaryReply reply = new SimulatedMobDropsSummaryReply();
        FakeMob fakeMob = new FakeMob(entityKey);
        if (fakeMob.isValid()) {
            reply.drops.addAll(MobSimulator.getInstance().getDropSummary(fakeMob));
        }
        return reply;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.drops.size());
        this.drops.forEach(d -> d.writeToPacket(buf));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this.lambda$null$2((Supplier)ctx)));
    }

    private /* synthetic */ Runnable lambda$null$2(Supplier ctx) {
        return () -> this.lambda$null$1((Supplier)ctx);
    }

    private /* synthetic */ void lambda$null$1(Supplier ctx) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71070_bA instanceof OracleContainer) {
            ((OracleContainer)player.field_71070_bA).handleSimulatedMobDropsSummaryReply(this);
        }
        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
    }
}

