/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.layout;

import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.layout.AbsolutePattern;
import ipsis.woot.modules.factory.layout.FactoryScanner;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.factory.multiblock.MultiBlockGlueProvider;
import ipsis.woot.modules.factory.multiblock.MultiBlockMaster;
import ipsis.woot.util.helper.PlayerHelper;
import ipsis.woot.util.helper.StringHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class FactoryHelper {
    public static void disconnectOld(World world, AbsolutePattern absolutePattern) {
        for (PatternBlock pb : absolutePattern.getBlocks()) {
            TileEntity te;
            if (!world.func_175667_e(pb.getBlockPos()) || !((te = world.func_175625_s(pb.getBlockPos())) instanceof MultiBlockGlueProvider)) continue;
            ((MultiBlockGlueProvider)te).getGlue().clearMaster();
        }
    }

    public static void connectNew(World world, AbsolutePattern absolutePattern, MultiBlockMaster master) {
        for (PatternBlock pb : absolutePattern.getBlocks()) {
            TileEntity te;
            if (pb.getFactoryComponent() == FactoryComponent.CONTROLLER && !absolutePattern.isValidControllerPos(pb.getBlockPos()) || !world.func_175667_e(pb.getBlockPos()) || !((te = world.func_175625_s(pb.getBlockPos())) instanceof MultiBlockGlueProvider)) continue;
            ((MultiBlockGlueProvider)te).getGlue().setMaster(master);
        }
    }

    static boolean isCorrectBlock(Block block, List<Block> validBlocks) {
        return validBlocks.contains(block);
    }

    public static BuildResult tryBuild(World world, BlockPos pos, PlayerEntity playerEntity, Direction facing, Tier tier) {
        if (!playerEntity.func_175142_cm()) {
            PlayerHelper.sendChatMessage(playerEntity, StringHelper.translate("chat.woot.intern.noedit"));
            return BuildResult.ERROR;
        }
        boolean allPlaced = true;
        AbsolutePattern absolutePattern = AbsolutePattern.create(world, tier, pos, facing);
        for (PatternBlock pb : absolutePattern.getBlocks()) {
            BlockState currState = world.func_180495_p(pb.getBlockPos());
            Block currBlock = currState.func_177230_c();
            List<Block> correctBlocks = pb.getFactoryComponent().getBlocks();
            List<ItemStack> correctItemStacks = pb.getFactoryComponent().getStacks();
            if (FactoryHelper.isCorrectBlock(currBlock, correctBlocks) || pb.getFactoryComponent() == FactoryComponent.CONTROLLER || pb.getFactoryComponent() == FactoryComponent.CELL) continue;
            allPlaced = false;
            Block placeBlock = correctBlocks.get(0);
            if (!PlayerHelper.playerHasFactoryComponent(playerEntity, correctItemStacks)) {
                PlayerHelper.sendChatMessage(playerEntity, StringHelper.translateFormat("chat.woot.intern.missingblock", StringHelper.translate(pb.getFactoryComponent().getTranslationKey())));
                return BuildResult.NO_BLOCK_IN_INV;
            }
            if (world.func_175660_a(playerEntity, pb.getBlockPos()) && (world.func_175623_d(pb.getBlockPos()) || currState.func_185904_a().func_76222_j())) {
                ItemStack takenStack = PlayerHelper.takeFactoryComponent(playerEntity, correctItemStacks);
                if (!takenStack.func_190926_b()) {
                    BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)pos);
                    world.func_180501_a(pb.getBlockPos(), placeBlock.func_176223_P(), 11);
                    if (ForgeEventFactory.onBlockPlace((Entity)playerEntity, (BlockSnapshot)blockSnapshot, (Direction)Direction.UP)) {
                        blockSnapshot.restore(true, false);
                        return BuildResult.ERROR;
                    }
                }
                return BuildResult.SUCCESS;
            }
            PlayerHelper.sendChatMessage(playerEntity, StringHelper.translateFormat("chat.woot.intern.noreplace", StringHelper.translate(pb.getFactoryComponent().getTranslationKey()), pb.getBlockPos().func_177958_n(), pb.getBlockPos().func_177956_o(), pb.getBlockPos().func_177952_p()));
            return BuildResult.ERROR;
        }
        return allPlaced ? BuildResult.ALL_BLOCKS_PLACED : BuildResult.ERROR;
    }

    public static void tryValidate(World world, BlockPos pos, PlayerEntity playerEntity, Direction facing, Tier tier) {
        PlayerHelper.sendActionBarMessage(playerEntity, StringHelper.translateFormat("chat.woot.intern.validate.start", StringHelper.translate(tier.getTranslationKey())));
        ArrayList<String> feedback = new ArrayList<String>();
        AbsolutePattern absolutePattern = AbsolutePattern.create(world, tier, pos, facing);
        if (!FactoryScanner.compareToWorld(absolutePattern, world, feedback)) {
            PlayerHelper.sendChatMessage(playerEntity, "----");
            PlayerHelper.sendActionBarMessage(playerEntity, StringHelper.translateFormat("chat.woot.intern.validate.invalid", StringHelper.translate(tier.getTranslationKey())));
            for (String s : feedback) {
                PlayerHelper.sendChatMessage(playerEntity, s);
            }
            PlayerHelper.sendChatMessage(playerEntity, "----");
        } else {
            PlayerHelper.sendActionBarMessage(playerEntity, StringHelper.translateFormat("chat.woot.intern.validate.valid", StringHelper.translate(tier.getTranslationKey())));
        }
    }

    public static enum BuildResult {
        ERROR,
        SUCCESS,
        NO_BLOCK_IN_INV,
        ALL_BLOCKS_PLACED;

    }
}

