/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.fluilds.FluidSetup;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.FactorySetup;
import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.PerkType;
import ipsis.woot.modules.factory.blocks.HeartContainer;
import ipsis.woot.modules.factory.calculators.CalculatorVersion2;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.modules.factory.generators.LootGeneration;
import ipsis.woot.modules.factory.layout.Layout;
import ipsis.woot.modules.factory.multiblock.MultiBlockMaster;
import ipsis.woot.modules.factory.network.HeartStaticDataReply;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.WootDebug;
import ipsis.woot.util.helper.StorageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeartTileEntity
extends TileEntity
implements ITickableTileEntity,
MultiBlockMaster,
WootDebug,
INamedContainerProvider {
    static final Logger LOGGER = LogManager.getLogger();
    Layout layout;
    FormedSetup formedSetup;
    Recipe recipe;
    TickTracker tickTracker = new TickTracker();
    boolean loadedFromNBT = false;
    int consumedUnits = 0;
    @OnlyIn(value=Dist.CLIENT)
    public ClientFactorySetup clientFactorySetup;

    public HeartTileEntity() {
        super((TileEntityType)FactorySetup.HEART_BLOCK_TILE.get());
        this.tickTracker.setStructureTickCount(20);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.layout != null) {
            this.layout.fullDisconnect();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.layout != null) {
            this.layout.fullDisconnect();
        }
    }

    public boolean isFormed() {
        return this.layout != null && this.layout.isFormed();
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.layout == null) {
            this.layout = new Layout();
            this.layout.setLocation(this.field_145850_b, this.field_174879_c, (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockStateProperties.field_208157_J));
            this.layout.setDirty();
        }
        if (!this.tickTracker.tick(this.field_145850_b)) {
            return;
        }
        this.layout.tick(this.tickTracker, this);
        if (this.layout.isFormed()) {
            if (this.layout.hasChanged()) {
                this.formedSetup = FormedSetup.createFromValidLayout(this.field_145850_b, this.layout);
                this.formedSetup.getAllMobs().forEach(m -> MobSimulator.getInstance().learn((FakeMob)m));
                this.recipe = CalculatorVersion2.calculate(this.formedSetup);
                if (this.loadedFromNBT) {
                    this.loadedFromNBT = false;
                } else {
                    this.consumedUnits = 0;
                    this.func_70296_d();
                }
                this.layout.clearChanged();
            }
            if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
                return;
            }
            this.tickRecipe();
            if (this.consumedUnits >= this.recipe.getNumTicks()) {
                IFluidHandler iFluidHandler;
                FluidStack fluidStack;
                LazyOptional<IFluidHandler> hdlr;
                this.consumedUnits = 0;
                this.func_70296_d();
                List<ItemStack> items = this.createItemIngredients(this.recipe, this.formedSetup);
                List<FluidStack> fluids = this.createFluidIngredients(this.recipe, this.formedSetup);
                if (this.hasItemIngredients(items, this.formedSetup) && this.hasFluidIngredients(fluids, this.formedSetup) && (hdlr = this.formedSetup.getCellFluidHandler()).isPresent() && (fluidStack = (iFluidHandler = (IFluidHandler)hdlr.orElseThrow(NullPointerException::new)).drain(this.recipe.getNumUnits(), IFluidHandler.FluidAction.SIMULATE)).getAmount() == this.recipe.getNumUnits()) {
                    LOGGER.debug("Generate loot");
                    this.consumeItemIngredients(items, this.formedSetup);
                    this.consumeFluidIngredients(fluids, this.formedSetup);
                    iFluidHandler.drain(this.recipe.getNumUnits(), IFluidHandler.FluidAction.EXECUTE);
                    LootGeneration.get().generate(this, this.formedSetup);
                }
            }
        }
    }

    private List<ItemStack> createItemIngredients(Recipe recipe, FormedSetup formedSetup) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (FakeMob fakeMob : formedSetup.getAllMobs()) {
            if (!recipe.items.containsKey(fakeMob)) continue;
            for (ItemStack itemStack : recipe.items.get(fakeMob)) {
                int count = itemStack.func_190916_E() * formedSetup.getAllMobParams().get(fakeMob).getMobCount(formedSetup.getAllPerks().containsKey((Object)PerkType.MASS));
                ItemStack newStack = itemStack.func_77946_l();
                newStack.func_190920_e(count);
                items.add(newStack);
            }
        }
        return StorageHelper.flattenItemStackList(items);
    }

    private List<FluidStack> createFluidIngredients(Recipe recipe, FormedSetup formedSetup) {
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        return fluids;
    }

    private boolean hasItemIngredients(List<ItemStack> items, FormedSetup formedSetup) {
        if (items.isEmpty()) {
            return true;
        }
        for (ItemStack itemStack : items) {
            int count = StorageHelper.getCount(itemStack, formedSetup.getImportHandlers());
            if (count != 0 && count >= itemStack.func_190916_E()) continue;
            return false;
        }
        return true;
    }

    private boolean hasFluidIngredients(List<FluidStack> fluids, FormedSetup formedSetup) {
        if (fluids.isEmpty()) {
            return true;
        }
        return true;
    }

    private void consumeItemIngredients(List<ItemStack> items, FormedSetup formedSetup) {
    }

    private void consumeFluidIngredients(List<FluidStack> fluids, FormedSetup formedSetup) {
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Progress")) {
            this.loadedFromNBT = true;
            this.consumedUnits = compound.func_74762_e("Progress");
            LOGGER.debug("read: loading progress " + this.consumedUnits);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.isFormed() && this.recipe != null) {
            compound.func_74768_a("Progress", this.consumedUnits);
            LOGGER.debug("write: saving progress " + this.consumedUnits);
        }
        return compound;
    }

    @Override
    public void interrupt() {
        if (this.layout != null) {
            this.layout.setDirty();
        }
    }

    void tickRecipe() {
        ++this.consumedUnits;
        this.func_70296_d();
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> HeartTileEntity");
        debug.add("      layout: " + this.layout);
        debug.add("      setup: " + this.formedSetup);
        debug.add("      recipe: " + this.recipe);
        debug.add("      consumed: " + this.consumedUnits);
        return debug;
    }

    public ITextComponent func_145748_c_() {
        if (this.isFormed()) {
            return new TranslationTextComponent(this.formedSetup.getTier().getTranslationKey(), new Object[0]);
        }
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new HeartContainer(windowId, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public int getFluidCapacity() {
        return this.formedSetup != null ? this.formedSetup.getCellCapacity() : 0;
    }

    public FluidStack getTankFluid() {
        return this.formedSetup != null ? new FluidStack((Fluid)FluidSetup.CONATUS_FLUID.get(), this.formedSetup.getCellFluidAmount()) : FluidStack.EMPTY;
    }

    public int getProgress() {
        if (this.formedSetup == null) {
            return 0;
        }
        return (int)(100.0f / (float)this.recipe.getNumTicks() * (float)this.consumedUnits);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientFactorySetup(ClientFactorySetup clientFactorySetup) {
        this.clientFactorySetup = clientFactorySetup;
    }

    public HeartStaticDataReply createStaticDataReply2() {
        return new HeartStaticDataReply(this.formedSetup, this.recipe);
    }

    public static class Recipe {
        int numTicks;
        int numUnits;
        public HashMap<FakeMob, List<ItemStack>> items = new HashMap();
        public HashMap<FakeMob, List<FluidStack>> fluids = new HashMap();

        public int getNumTicks() {
            return this.numTicks;
        }

        public int getNumUnits() {
            return this.numUnits;
        }

        public Recipe() {
            this.numTicks = 1;
            this.numUnits = 1;
        }

        public Recipe(int numTicks, int numUnits) {
            this.numTicks = MathHelper.func_76125_a((int)numTicks, (int)1, (int)Integer.MAX_VALUE);
            this.numUnits = MathHelper.func_76125_a((int)numUnits, (int)1, (int)Integer.MAX_VALUE);
        }

        public void addItem(FakeMob fakeMob, ItemStack itemStack) {
            if (!this.items.containsKey(fakeMob)) {
                this.items.put(fakeMob, new ArrayList());
            }
            if (!itemStack.func_190926_b()) {
                this.items.get(fakeMob).add(itemStack.func_77946_l());
            }
        }

        public void addFluid(FakeMob fakeMob, FluidStack fluidStack) {
            if (!this.fluids.containsKey(fakeMob)) {
                this.fluids.put(fakeMob, new ArrayList());
            }
            if (!fluidStack.isEmpty()) {
                this.fluids.get(fakeMob).add(fluidStack.copy());
            }
        }

        public String toString() {
            return "Recipe{numTicks=" + this.numTicks + ", numUnits=" + this.numUnits + ", items=" + this.items.size() + ", fluids=" + this.fluids.size() + '}';
        }
    }

    public class TickTracker {
        long lastGameTime = -1L;
        int structureTicksTimeout = 0;
        int currStructureTicks = 0;

        public boolean tick(World world) {
            boolean realTick = false;
            long currGameTime = world.func_82737_E();
            if (((Boolean)FactoryConfiguration.TICK_ACCEL.get()).booleanValue() || this.lastGameTime != currGameTime) {
                this.lastGameTime = currGameTime;
                realTick = true;
                if (this.structureTicksTimeout > 0) {
                    ++this.currStructureTicks;
                }
            }
            return realTick;
        }

        public boolean hasStructureTickExpired() {
            return this.structureTicksTimeout > 0 && this.currStructureTicks >= this.structureTicksTimeout;
        }

        public void setStructureTickCount(int ticks) {
            this.structureTicksTimeout = ticks;
        }

        public void resetStructureTickCount() {
            this.currStructureTicks = 0;
        }
    }
}

