/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import ipsis.woot.config.ConfigDefaults;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class FactoryConfiguration {
    public static ForgeConfigSpec.BooleanValue TICK_ACCEL;
    public static ForgeConfigSpec.IntValue CELL_1_CAPACITY;
    public static ForgeConfigSpec.IntValue CELL_1_MAX_TRANSFER;
    public static ForgeConfigSpec.IntValue CELL_2_CAPACITY;
    public static ForgeConfigSpec.IntValue CELL_2_MAX_TRANSFER;
    public static ForgeConfigSpec.IntValue CELL_3_CAPACITY;
    public static ForgeConfigSpec.IntValue CELL_3_MAX_TRANSFER;
    public static ForgeConfigSpec.IntValue CELL_4_CAPACITY;
    public static ForgeConfigSpec.IntValue CELL_4_MAX_TRANSFER;
    public static ForgeConfigSpec.IntValue MASS_COUNT;
    public static ForgeConfigSpec.IntValue SPAWN_TICKS;
    public static ForgeConfigSpec.IntValue UNITS_PER_HEALTH;
    public static ForgeConfigSpec.IntValue MOB_SHARD_KILLS;
    public static ForgeConfigSpec.IntValue TIER_1_MAX_UNITS;
    public static ForgeConfigSpec.IntValue TIER_2_MAX_UNITS;
    public static ForgeConfigSpec.IntValue TIER_3_MAX_UNITS;
    public static ForgeConfigSpec.IntValue TIER_4_MAX_UNITS;
    public static ForgeConfigSpec.IntValue TIER_5_MAX_UNITS;
    public static ForgeConfigSpec.IntValue EFFICIENCY_1;
    public static ForgeConfigSpec.IntValue EFFICIENCY_2;
    public static ForgeConfigSpec.IntValue EFFICIENCY_3;
    public static ForgeConfigSpec.IntValue MASS_COUNT_1;
    public static ForgeConfigSpec.IntValue MASS_COUNT_2;
    public static ForgeConfigSpec.IntValue MASS_COUNT_3;
    public static ForgeConfigSpec.IntValue RATE_1;
    public static ForgeConfigSpec.IntValue RATE_2;
    public static ForgeConfigSpec.IntValue RATE_3;
    public static ForgeConfigSpec.IntValue XP_1;
    public static ForgeConfigSpec.IntValue XP_2;
    public static ForgeConfigSpec.IntValue XP_3;
    public static ForgeConfigSpec.IntValue TIER_SHARD_1;
    public static ForgeConfigSpec.IntValue TIER_SHARD_2;
    public static ForgeConfigSpec.IntValue TIER_SHARD_3;
    public static ForgeConfigSpec.DoubleValue T1_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T1_FARM_DROP_SHARD_WEIGHTS;
    public static ForgeConfigSpec.DoubleValue T2_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T2_FARM_DROP_SHARD_WEIGHTS;
    public static ForgeConfigSpec.DoubleValue T3_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T3_FARM_DROP_SHARD_WEIGHTS;
    public static ForgeConfigSpec.DoubleValue T4_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T4_FARM_DROP_SHARD_WEIGHTS;
    public static ForgeConfigSpec.DoubleValue T5_FARM_DROP_CHANCE;
    public static ForgeConfigSpec.ConfigValue<List<Integer>> T5_FARM_DROP_SHARD_WEIGHTS;

    public static void init(ForgeConfigSpec.Builder COMMON_BUILDER, ForgeConfigSpec.Builder CLIENT_BUILDER) {
        COMMON_BUILDER.comment("Settings for the factory").push("factory");
        CLIENT_BUILDER.comment("Settings for the factory").push("factory");
        COMMON_BUILDER.push("general");
        TICK_ACCEL = COMMON_BUILDER.comment("Allow tick acceleration to be used on the factory").define("tickAcceleration", true);
        TIER_1_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 1 mob").defineInRange("t1MaxHealth", 20, 5, Integer.MAX_VALUE);
        TIER_2_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 2 mob").defineInRange("t2MaxHealth", 40, 5, Integer.MAX_VALUE);
        TIER_3_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 3 mob").defineInRange("t3MaxHealth", 60, 5, Integer.MAX_VALUE);
        TIER_4_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 4 mob").defineInRange("t4MaxHealth", Integer.MAX_VALUE, 5, Integer.MAX_VALUE);
        TIER_5_MAX_UNITS = COMMON_BUILDER.comment("Max health for a tier 5 mob").defineInRange("t5MaxHealth", Integer.MAX_VALUE, 5, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("base");
        MASS_COUNT = COMMON_BUILDER.comment("Number of mobs to spawn").defineInRange("massCount", 1, 1, 100);
        SPAWN_TICKS = COMMON_BUILDER.comment("Number of ticks to spawn a mob").defineInRange("spawnTicks", 320, 1, 65535);
        UNITS_PER_HEALTH = COMMON_BUILDER.comment("Number of units for each health").defineInRange("mbPerHealth", 10, 1, 65535);
        MOB_SHARD_KILLS = COMMON_BUILDER.comment("Number of kills to program the shard").defineInRange("shardKills", 5, 1, 65535);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("basicCell");
        CELL_1_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").worldRestart().defineInRange("tankCapacity", 10000, 1, Integer.MAX_VALUE);
        CELL_1_MAX_TRANSFER = COMMON_BUILDER.comment("Tank max transfer rate (mb/t per side)").worldRestart().defineInRange("tankRxPerTick", 1000, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("advancedCell");
        CELL_2_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").worldRestart().defineInRange("tankCapacity", 50000, 1, Integer.MAX_VALUE);
        CELL_2_MAX_TRANSFER = COMMON_BUILDER.comment("Tank max transfer rate (mb/t per side)").worldRestart().defineInRange("tankRxPerTick", 5000, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("premiumCell");
        CELL_3_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").worldRestart().defineInRange("tankCapacity", 100000, 1, Integer.MAX_VALUE);
        CELL_3_MAX_TRANSFER = COMMON_BUILDER.comment("Tank max transfer rate (mb/t per side)").worldRestart().defineInRange("tankRxPerTick", 10000, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("ultimateCell");
        CELL_4_CAPACITY = COMMON_BUILDER.comment("Tank capacity (mb)").worldRestart().defineInRange("tankCapacity", 1000000, 1, Integer.MAX_VALUE);
        CELL_4_MAX_TRANSFER = COMMON_BUILDER.comment("Tank max transfer rate (mb/t per side)").worldRestart().defineInRange("tankRxPerTick", 25000, 1, Integer.MAX_VALUE);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("perks");
        COMMON_BUILDER.push("efficiency");
        EFFICIENCY_1 = COMMON_BUILDER.comment("Percentage reduction for efficiency 1 perks").defineInRange("l1Reduction", 15, 0, 100);
        EFFICIENCY_2 = COMMON_BUILDER.comment("Percentage reduction for efficiency 2 perks").defineInRange("l2Reduction", 25, 0, 100);
        EFFICIENCY_3 = COMMON_BUILDER.comment("Percentage reduction for efficiency 3 perks").defineInRange("l3Reduction", 30, 0, 100);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("mass");
        MASS_COUNT_1 = COMMON_BUILDER.comment("Number of mobs to spawn for mass 1 perks").defineInRange("l1MobCount", 2, 1, 100);
        MASS_COUNT_2 = COMMON_BUILDER.comment("Number of mobs to spawn for mass 2 perks").defineInRange("l2MobCount", 4, 1, 100);
        MASS_COUNT_3 = COMMON_BUILDER.comment("Number of mobs to spawn for mass 3 perks").defineInRange("l3MobCount", 6, 1, 100);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("rate");
        RATE_1 = COMMON_BUILDER.comment("Percentage reduction in spawn time for rate 1 perks").defineInRange("l1Reduction", 20, 1, 99);
        RATE_2 = COMMON_BUILDER.comment("Percentage reduction in spawn time for rate 2 perks").defineInRange("l2Reduction", 50, 1, 99);
        RATE_3 = COMMON_BUILDER.comment("Percentage reduction in spawn time for rate 3 perks").defineInRange("l3Reduction", 75, 1, 99);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("tierShard");
        TIER_SHARD_1 = COMMON_BUILDER.comment("Number of chances to generate essence for tier 1 perk").defineInRange("l1Rolls", 1, 0, Integer.MAX_VALUE);
        TIER_SHARD_2 = COMMON_BUILDER.comment("Number of chances to generate essence for tier 2 perk").defineInRange("l2Rolls", 2, 0, Integer.MAX_VALUE);
        TIER_SHARD_3 = COMMON_BUILDER.comment("Number of chances to generate essence for tier 3 perk").defineInRange("l3Rolls", 3, 0, Integer.MAX_VALUE);
        T1_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 1 factory").defineInRange("t1DropChance", 5.0, 0.0, 100.0);
        T2_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 2 factory").defineInRange("t2DropChance", 10.0, 0.0, 100.0);
        T3_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 3 factory").defineInRange("t3DropChance", 20.0, 0.0, 100.0);
        T4_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 4 factory").defineInRange("t4DropChance", 30.0, 0.0, 100.0);
        T5_FARM_DROP_CHANCE = COMMON_BUILDER.comment("Chance to drop essence from a Tier 5 factory").defineInRange("t5DropChance", 40.0, 0.0, 100.0);
        T1_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 1 factory").define("t1DropWeights", ConfigDefaults.Factory.T1_SHARD_DROP_WEIGHTS_DEF);
        T2_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 2 factory").define("t2DropWeights", ConfigDefaults.Factory.T2_SHARD_DROP_WEIGHTS_DEF);
        T3_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 3 factory").define("t3DropWeights", ConfigDefaults.Factory.T3_SHARD_DROP_WEIGHTS_DEF);
        T4_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 4 factory").define("t4DropWeights", ConfigDefaults.Factory.T4_SHARD_DROP_WEIGHTS_DEF);
        T5_FARM_DROP_SHARD_WEIGHTS = COMMON_BUILDER.comment("Weights of the Celadon, Cerulean, Byzantium shard from a Tier 5 factory").define("t5DropWeights", ConfigDefaults.Factory.T5_SHARD_DROP_WEIGHTS_DEF);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("xp");
        XP_1 = COMMON_BUILDER.comment("Percentage generate of XP for xp 1 perks").defineInRange("l1Generate", 100, 0, 1000);
        XP_2 = COMMON_BUILDER.comment("Percentage generate of XP for xp 2 perks").defineInRange("l2Generate", 125, 0, 1000);
        XP_3 = COMMON_BUILDER.comment("Percentage generate of XP for xp 3 perks").defineInRange("l3Generate", 150, 0, 1000);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        CLIENT_BUILDER.pop();
        COMMON_BUILDER.pop();
    }
}

