/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.compat.jei;

import ipsis.woot.compat.jei.WootJeiPlugin;
import ipsis.woot.crafting.InfuserRecipe;
import ipsis.woot.modules.infuser.InfuserSetup;
import ipsis.woot.util.helper.StringHelper;
import java.awt.Color;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class InfuserRecipeCategory
implements IRecipeCategory<InfuserRecipe>,
ITooltipCallback<ItemStack> {
    public static final ResourceLocation UID = new ResourceLocation("woot", "infuser");
    private static IDrawableStatic background;
    private static IDrawable icon;

    public InfuserRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = new ResourceLocation("woot", "textures/gui/jei/infuser.png");
        background = guiHelper.createDrawable(resourceLocation, 0, 0, 180, 87);
        icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)InfuserSetup.INFUSER_BLOCK.get()));
    }

    public Class<? extends InfuserRecipe> getRecipeClass() {
        return InfuserRecipe.class;
    }

    public void setIngredients(InfuserRecipe recipe, IIngredients iIngredients) {
        iIngredients.setInputLists(VanillaTypes.ITEM, recipe.getInputs());
        iIngredients.setInput(VanillaTypes.FLUID, (Object)recipe.getFluidInput());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public void onTooltip(int slot, boolean isInput, ItemStack itemStack, List<String> list) {
        if (slot != 2) {
            return;
        }
        if (itemStack.func_77973_b() == Items.field_151134_bR || itemStack.func_77948_v()) {
            if (itemStack.func_190916_E() == 1) {
                list.add("Random enchantment I");
            } else if (itemStack.func_190916_E() == 2) {
                list.add("Random enchantment II");
            } else if (itemStack.func_190916_E() == 3) {
                list.add("Random enchantment III");
            } else if (itemStack.func_190916_E() == 4) {
                list.add("Random enchantment IV");
            } else if (itemStack.func_190916_E() == 5) {
                list.add("Random enchantment V");
            }
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, InfuserRecipe infuserRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, true, 45, 39);
        itemStacks.init(1, true, 63, 39);
        itemStacks.init(2, false, 117, 39);
        itemStacks.addTooltipCallback((ITooltipCallback)this);
        itemStacks.set(iIngredients);
        IGuiFluidStackGroup fluidStacks = iRecipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 154, 18, 16, 60, WootJeiPlugin.maxInfuserRecipeMb, true, null);
        fluidStacks.set(iIngredients);
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public String getTitle() {
        return StringHelper.translate("gui.woot.infuser.name");
    }

    public IDrawableStatic getBackground() {
        return background;
    }

    public IDrawable getIcon() {
        return icon;
    }

    public void draw(InfuserRecipe recipe, double mouseX, double mouseY) {
        IJeiRuntime runtime = WootJeiPlugin.jeiRuntime;
        if (runtime != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.field_71466_p.func_211126_b(String.format("%d RF", recipe.getEnergy()), 70.0f, 68.0f, Color.BLACK.getRGB());
        }
    }
}

