/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.fluid;

import com.hrznstudio.titanium.fluid.TitaniumFluid;
import com.hrznstudio.titanium.module.api.IAlternativeEntries;
import com.hrznstudio.titanium.module.api.RegistryManager;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TitaniumFluidInstance
extends ForgeRegistryEntry<TitaniumFluidInstance>
implements IAlternativeEntries {
    private TitaniumFluid flowingFluid;
    private TitaniumFluid sourceFluid;
    private Item bucketFluid;
    private Block blockFluid;

    public TitaniumFluidInstance(String modid, String fluid, FluidAttributes.Builder attributes, boolean hasBucket, ItemGroup group) {
        this.sourceFluid = (TitaniumFluid)new TitaniumFluid.Source(attributes).setRegistryName(modid, fluid);
        this.flowingFluid = (TitaniumFluid)new TitaniumFluid.Flowing(attributes).setRegistryName(modid, fluid + "_fluid");
        this.sourceFluid = this.sourceFluid.setSourceFluid(this.sourceFluid).setFlowingFluid((Fluid)this.flowingFluid);
        this.flowingFluid = this.flowingFluid.setSourceFluid(this.sourceFluid).setFlowingFluid((Fluid)this.flowingFluid);
        if (hasBucket) {
            this.bucketFluid = (Item)new BucketItem((Fluid)this.sourceFluid, new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(group)).setRegistryName(modid, fluid + "_bucket");
        }
        this.blockFluid = (Block)new FlowingFluidBlock(this.sourceFluid, Block.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()){}.setRegistryName(modid, fluid + "_block");
        this.sourceFluid.setBlockFluid(this.blockFluid).setBucketFluid(this.bucketFluid);
        this.flowingFluid.setBlockFluid(this.blockFluid).setBucketFluid(this.bucketFluid);
    }

    @Override
    public void addAlternatives(RegistryManager<?> registry) {
        registry.content(Fluid.class, this.flowingFluid);
        registry.content(Fluid.class, this.sourceFluid);
        registry.content(Block.class, this.blockFluid);
        if (this.bucketFluid != null) {
            registry.content(Item.class, this.bucketFluid);
        }
    }

    public TitaniumFluid getFlowingFluid() {
        return this.flowingFluid;
    }

    public TitaniumFluid getSourceFluid() {
        return this.sourceFluid;
    }

    public Item getBucketFluid() {
        return this.bucketFluid;
    }

    public Block getBlockFluid() {
        return this.blockFluid;
    }

    public void setBucketFluid(Item bucketFluid) {
        this.bucketFluid = bucketFluid;
        this.sourceFluid.setBucketFluid(bucketFluid);
        this.flowingFluid.setBucketFluid(bucketFluid);
    }
}

