/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.addon.interfaces.ICanMouseDrag;
import com.hrznstudio.titanium.client.screen.addon.interfaces.IClickable;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.glfw.GLFW;

public abstract class ScreenAddonScreen
extends Screen
implements IScreenAddonConsumer {
    public int x;
    public int y;
    private IAssetProvider assetProvider;
    private List<IScreenAddon> addonList;
    private boolean drawBackground;
    private boolean isMouseDragging;
    private int dragX;
    private int dragY;

    public ScreenAddonScreen(IAssetProvider assetProvider, boolean drawBackground) {
        super((ITextComponent)new StringTextComponent(""));
        this.assetProvider = assetProvider;
        this.drawBackground = drawBackground;
    }

    public void init() {
        super.init();
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.x = this.width / 2 - background.getArea().width / 2;
        this.y = this.height / 2 - background.getArea().height / 2;
        this.addonList = this.guiAddons().stream().map(IFactory::create).collect(Collectors.toList());
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        this.renderBackground(mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.pushMatrix();
        this.renderForeground(mouseX, mouseY, partialTicks);
        RenderSystem.popMatrix();
    }

    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        this.checkForMouseDrag(mouseX, mouseY);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.drawBackground) {
            this.renderBackground();
            AssetUtil.drawAsset(this, this.assetProvider.getAsset(AssetTypes.BACKGROUND), this.x, this.y);
        }
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawBackgroundLayer(this, this.assetProvider, this.x, this.y, mouseX, mouseY, partialTicks));
    }

    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawForegroundLayer(this, this.assetProvider, this.x, this.y, mouseX, mouseY));
        for (IScreenAddon iScreenAddon : this.addonList) {
            if (!iScreenAddon.isInside(this, mouseX - this.x, mouseY - this.y) || iScreenAddon.getTooltipLines().isEmpty()) continue;
            this.renderTooltip(iScreenAddon.getTooltipLines(), mouseX, mouseY);
        }
    }

    public abstract List<IFactory<IScreenAddon>> guiAddons();

    private void checkForMouseDrag(int mouseX, int mouseY) {
        if (GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)0) == 1) {
            if (!this.isMouseDragging) {
                this.isMouseDragging = true;
            } else {
                for (IScreenAddon iScreenAddon : this.addonList) {
                    if (!(iScreenAddon instanceof ICanMouseDrag) || !iScreenAddon.isInside(null, mouseX - this.x, mouseY - this.y)) continue;
                    ((ICanMouseDrag)((Object)iScreenAddon)).drag(mouseX - this.dragX, mouseY - this.dragY);
                }
            }
            this.dragX = mouseX;
            this.dragY = mouseY;
        } else {
            this.isMouseDragging = false;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.addonList.stream().filter(iScreenAddon -> iScreenAddon instanceof IClickable && iScreenAddon.isInside(this, mouseX - (double)this.x, mouseY - (double)this.y)).forEach(iScreenAddon -> ((IClickable)((Object)iScreenAddon)).handleClick(this, this.x, this.y, mouseX, mouseY, mouseButton));
        return false;
    }

    public List<IScreenAddon> getAddons() {
        return this.addonList;
    }
}

