/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import mekanism.common.Mekanism;
import mekanism.common.util.EnumUtils;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public final class VoxelShapeUtils {
    private static final Vec3d fromOrigin = new Vec3d(-0.5, -0.5, -0.5);

    public static void print(double x1, double y1, double z1, double x2, double y2, double z2) {
        Mekanism.logger.info("makeCuboidShape(" + Math.min(x1, x2) + ", " + Math.min(y1, y2) + ", " + Math.min(z1, z2) + ", " + Math.max(x1, x2) + ", " + Math.max(y1, y2) + ", " + Math.max(z1, z2) + "),");
    }

    public static void printSimplified(String name, VoxelShape shape) {
        Mekanism.logger.info("Simplified: " + name);
        shape.func_197753_c().func_197756_d().forEach(box -> VoxelShapeUtils.print(box.field_72340_a * 16.0, box.field_72338_b * 16.0, box.field_72339_c * 16.0, box.field_72336_d * 16.0, box.field_72337_e * 16.0, box.field_72334_f * 16.0));
    }

    public static AxisAlignedBB rotate(AxisAlignedBB box, Direction side) {
        switch (side) {
            case DOWN: {
                return box;
            }
            case UP: {
                return new AxisAlignedBB(box.field_72340_a, -box.field_72338_b, -box.field_72339_c, box.field_72336_d, -box.field_72337_e, -box.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(box.field_72340_a, -box.field_72339_c, box.field_72338_b, box.field_72336_d, -box.field_72334_f, box.field_72337_e);
            }
            case SOUTH: {
                return new AxisAlignedBB(-box.field_72340_a, box.field_72339_c, -box.field_72338_b, -box.field_72336_d, box.field_72334_f, -box.field_72337_e);
            }
            case WEST: {
                return new AxisAlignedBB(box.field_72338_b, -box.field_72339_c, -box.field_72340_a, box.field_72337_e, -box.field_72334_f, -box.field_72336_d);
            }
            case EAST: {
                return new AxisAlignedBB(-box.field_72338_b, box.field_72339_c, box.field_72340_a, -box.field_72337_e, box.field_72334_f, box.field_72336_d);
            }
        }
        return box;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB box, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return box;
            }
            case CLOCKWISE_90: {
                return new AxisAlignedBB(-box.field_72339_c, box.field_72338_b, box.field_72340_a, -box.field_72334_f, box.field_72337_e, box.field_72336_d);
            }
            case CLOCKWISE_180: {
                return new AxisAlignedBB(-box.field_72340_a, box.field_72338_b, -box.field_72339_c, -box.field_72336_d, box.field_72337_e, -box.field_72334_f);
            }
            case COUNTERCLOCKWISE_90: {
                return new AxisAlignedBB(box.field_72339_c, box.field_72338_b, -box.field_72340_a, box.field_72334_f, box.field_72337_e, -box.field_72336_d);
            }
        }
        return box;
    }

    public static AxisAlignedBB rotateHorizontal(AxisAlignedBB box, Direction side) {
        switch (side) {
            case NORTH: {
                return VoxelShapeUtils.rotate(box, Rotation.NONE);
            }
            case SOUTH: {
                return VoxelShapeUtils.rotate(box, Rotation.CLOCKWISE_180);
            }
            case WEST: {
                return VoxelShapeUtils.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            }
            case EAST: {
                return VoxelShapeUtils.rotate(box, Rotation.CLOCKWISE_90);
            }
        }
        return box;
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        return VoxelShapeUtils.rotate(shape, box -> VoxelShapeUtils.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AxisAlignedBB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.func_197756_d();
        for (AxisAlignedBB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(VoxelShapes.func_197881_a((AxisAlignedBB)((AxisAlignedBB)rotateFunction.apply(sourceBoundingBox.func_72317_d(VoxelShapeUtils.fromOrigin.field_72450_a, VoxelShapeUtils.fromOrigin.field_72448_b, VoxelShapeUtils.fromOrigin.field_72449_c))).func_72317_d(-VoxelShapeUtils.fromOrigin.field_72450_a, -VoxelShapeUtils.fromOrigin.field_72449_c, -VoxelShapeUtils.fromOrigin.field_72449_c)));
        }
        return VoxelShapeUtils.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelShapeUtils.batchCombine(VoxelShapes.func_197880_a(), IBooleanFunction.field_223244_o_, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelShapeUtils.combine(shapes, true);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes, boolean simplify) {
        return VoxelShapeUtils.batchCombine(VoxelShapes.func_197880_a(), IBooleanFunction.field_223244_o_, simplify, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelShapeUtils.batchCombine(VoxelShapes.func_197868_b(), IBooleanFunction.field_223234_e_, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, IBooleanFunction function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)shape, (IBooleanFunction)function);
        }
        return simplify ? combinedShape.func_197753_c() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, IBooleanFunction function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)shape, (IBooleanFunction)function);
        }
        return simplify ? combinedShape.func_197753_c() : combinedShape;
    }

    public static VoxelShape getSlope(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float rotationPointX, float rotationPointY, float rotationPointZ, float rotateAngleX, float rotateAngleY, float rotateAngleZ, boolean print) {
        float shiftX = 8.0f - rotationPointX;
        float shiftY = 24.0f - rotationPointY;
        float shiftZ = 8.0f + rotationPointZ;
        if (rotateAngleX == 0.0f && rotateAngleY == 0.0f && rotateAngleZ == 0.0f) {
            if (print) {
                VoxelShapeUtils.print(-maxX + shiftX, -maxY + shiftY, maxZ + shiftZ, -minX + shiftX, -minY + shiftY, minZ + shiftZ);
                return VoxelShapes.func_197880_a();
            }
            return Block.func_208617_a((double)(-maxX + shiftX), (double)(-maxY + shiftY), (double)(maxZ + shiftZ), (double)(-minX + shiftX), (double)(-minY + shiftY), (double)(minZ + shiftZ));
        }
        if (print) {
            Vec3f min = VoxelShapeUtils.rotateVector(minX, minY, minZ, rotateAngleX, rotateAngleY, rotateAngleZ).mul(-1.0f, -1.0f, 1.0f);
            Vec3f max = VoxelShapeUtils.rotateVector(maxX, minY, maxZ, rotateAngleX, rotateAngleY, rotateAngleZ).mul(-1.0f, -1.0f, 1.0f);
            float xCenter = (minX + maxX) / 2.0f;
            float zCenter = (minZ + maxZ) / 2.0f;
            Vec3f minCenter = VoxelShapeUtils.rotateVector(xCenter, minY, zCenter, rotateAngleX, rotateAngleY, rotateAngleZ).mul(-1.0f, -1.0f, 1.0f);
            Vec3f maxCenter = VoxelShapeUtils.rotateVector(xCenter, minY, zCenter, rotateAngleX, rotateAngleY, rotateAngleZ).mul(-1.0f, -1.0f, 1.0f);
            Mekanism.logger.info("Min: {}, Max: {}, MinCenter: {}, MaxCenter: {}", (Object)min.add(shiftX, shiftY, shiftZ), (Object)max.add(shiftX, shiftY, shiftZ), (Object)minCenter.add(shiftX, shiftY, shiftZ), (Object)maxCenter.add(shiftX, shiftY, shiftZ));
            return VoxelShapes.func_197880_a();
        }
        Vec3f start1 = VoxelShapeUtils.rotateVector(minX, minY, minZ, rotateAngleX, rotateAngleY, rotateAngleZ);
        Vec3f start2 = VoxelShapeUtils.rotateVector(maxX, minY, minZ, rotateAngleX, rotateAngleY, rotateAngleZ);
        Vec3f start3 = VoxelShapeUtils.rotateVector(minX, minY, maxZ, rotateAngleX, rotateAngleY, rotateAngleZ);
        Vec3f start4 = VoxelShapeUtils.rotateVector(maxX, minY, maxZ, rotateAngleX, rotateAngleY, rotateAngleZ);
        Vec3f startSum = start1.add(start2).add(start3).add(start4);
        Vec3f startAvg = startSum.scale(0.25f);
        Vec3f end1 = VoxelShapeUtils.rotateVector(minX, maxY, minZ, rotateAngleX, rotateAngleY, rotateAngleZ);
        Vec3f end2 = VoxelShapeUtils.rotateVector(maxX, maxY, minZ, rotateAngleX, rotateAngleY, rotateAngleZ);
        Vec3f end3 = VoxelShapeUtils.rotateVector(minX, maxY, maxZ, rotateAngleX, rotateAngleY, rotateAngleZ);
        Vec3f end4 = VoxelShapeUtils.rotateVector(maxX, maxY, maxZ, rotateAngleX, rotateAngleY, rotateAngleZ);
        Vec3f endSum = end1.add(end2).add(end3).add(end4);
        Vec3f endAvg = endSum.scale(0.25f);
        Vec3f end = startAvg.mul(-1.0f, -1.0f, 1.0f);
        Vec3f start = endAvg.mul(-1.0f, -1.0f, 1.0f);
        float startX = start.x + shiftX;
        float startY = start.y + shiftY;
        float startZ = start.z + shiftZ;
        float endX = end.x + shiftX;
        float endY = end.y + shiftY;
        float endZ = end.z + shiftZ;
        ShapeCreator shapeCreator = (x, y, z) -> Block.func_208617_a((double)(x - 0.5f), (double)(y - 0.5f), (double)(z - 0.5f), (double)(x + 0.5f), (double)(y + 0.5f), (double)(z + 0.5f));
        return VoxelShapeUtils.createSlope(startX, startY, startZ, endX, endY, endZ, shapeCreator);
    }

    private static Vec3f rotateVector(float x, float y, float z, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        float xReturn = x;
        float yReturn = y;
        float zReturn = z;
        if (rotateAngleZ != 0.0f) {
            float sinZ = (float)Math.sin(rotateAngleZ);
            float cosZ = (float)Math.cos(rotateAngleZ);
            xReturn = x * cosZ - y * sinZ;
            yReturn = x * sinZ + y * cosZ;
            x = xReturn;
            y = yReturn;
        }
        if (rotateAngleY != 0.0f) {
            float sinY = (float)Math.sin(rotateAngleY);
            float cosY = (float)Math.cos(rotateAngleY);
            xReturn = x * cosY + z * sinY;
            zReturn = z * cosY - x * sinY;
            x = xReturn;
            z = zReturn;
        }
        if (rotateAngleX != 0.0f) {
            float sinX = (float)Math.sin(rotateAngleX);
            float cosX = (float)Math.cos(rotateAngleX);
            yReturn = y * cosX - z * sinX;
            zReturn = y * sinX + z * cosX;
        }
        return new Vec3f(xReturn, yReturn, zReturn);
    }

    public static VoxelShape createSlope(float xStart, float yStart, float zStart, float xEnd, float yEnd, float zEnd, ShapeCreator shapeCreator) {
        float xDif = xEnd - xStart;
        float yDif = yEnd - yStart;
        float zDif = zEnd - zStart;
        if (xDif == 0.0f && yDif == 0.0f && zDif == 0.0f) {
            return VoxelShapes.func_197880_a();
        }
        int steps = (int)Math.ceil((double)Math.max(Math.max(Math.abs(xDif), Math.abs(yDif)), Math.abs(zDif)) * 4.0 / 3.0);
        double tPartial = 1.0 / (double)steps;
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        for (int step = 0; step <= steps; ++step) {
            float t = (float)(tPartial * (double)step);
            float x = xStart + xDif * t;
            float y = yStart + yDif * t;
            float z = zStart + zDif * t;
            shapes.add(shapeCreator.createShape(x, y, z));
        }
        return VoxelShapeUtils.combine(shapes, false);
    }

    public static void setShape(VoxelShape shape, VoxelShape[] dest, boolean verticalAxis) {
        VoxelShapeUtils.setShape(shape, dest, verticalAxis, false);
    }

    public static void setShape(VoxelShape shape, VoxelShape[] dest, boolean verticalAxis, boolean invert) {
        Direction[] dirs;
        for (Direction side : dirs = verticalAxis ? EnumUtils.DIRECTIONS : EnumUtils.HORIZONTAL_DIRECTIONS) {
            dest[verticalAxis ? side.ordinal() : side.ordinal() - 2] = verticalAxis ? VoxelShapeUtils.rotate(shape, invert ? side.func_176734_d() : side) : VoxelShapeUtils.rotateHorizontal(shape, side);
        }
    }

    public static void setShape(VoxelShape shape, VoxelShape[] dest) {
        VoxelShapeUtils.setShape(shape, dest, false, false);
    }

    private static class Vec3f {
        public final float x;
        public final float y;
        public final float z;

        public Vec3f(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vec3f scale(float factor) {
            return this.mul(factor, factor, factor);
        }

        public Vec3f subtract(Vec3f vec) {
            return this.subtract(vec.x, vec.y, vec.z);
        }

        public Vec3f subtract(float x, float y, float z) {
            return this.add(-x, -y, -z);
        }

        public Vec3f add(Vec3f vec) {
            return this.add(vec.x, vec.y, vec.z);
        }

        public Vec3f add(float x, float y, float z) {
            return new Vec3f(this.x + x, this.y + y, this.z + z);
        }

        public Vec3f mul(float factorX, float factorY, float factorZ) {
            return new Vec3f(this.x * factorX, this.y * factorY, this.z * factorZ);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }

    @FunctionalInterface
    public static interface ShapeCreator {
        public VoxelShape createShape(float var1, float var2, float var3);
    }
}

