/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public final class TransporterUtils {
    public static final List<EnumColor> colors = Arrays.asList(EnumColor.DARK_BLUE, EnumColor.DARK_GREEN, EnumColor.DARK_AQUA, EnumColor.DARK_RED, EnumColor.PURPLE, EnumColor.INDIGO, EnumColor.BRIGHT_GREEN, EnumColor.AQUA, EnumColor.RED, EnumColor.PINK, EnumColor.YELLOW, EnumColor.BLACK);

    @Nullable
    public static EnumColor readColor(int inputColor) {
        return inputColor == -1 ? null : colors.get(inputColor);
    }

    public static int getColorIndex(@Nullable EnumColor color) {
        return color == null ? -1 : colors.indexOf((Object)color);
    }

    public static boolean isValidAcceptorOnSide(TileEntity tile, Direction side) {
        if (CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, null).filter(transmitter -> TransmissionType.checkTransmissionType(transmitter, TransmissionType.ITEM)).isPresent()) {
            return false;
        }
        return InventoryUtils.isItemHandler(tile, side.func_176734_d());
    }

    public static EnumColor increment(EnumColor color) {
        if (color == null) {
            return colors.get(0);
        }
        if (colors.indexOf((Object)color) == colors.size() - 1) {
            return null;
        }
        return colors.get(colors.indexOf((Object)color) + 1);
    }

    public static EnumColor decrement(EnumColor color) {
        if (color == null) {
            return colors.get(colors.size() - 1);
        }
        if (colors.indexOf((Object)color) == 0) {
            return null;
        }
        return colors.get(colors.indexOf((Object)color) - 1);
    }

    public static void drop(ILogisticalTransporter tile, TransporterStack stack) {
        float[] pos = stack.hasPath() ? TransporterUtils.getStackPosition(tile, stack, 0.0f) : new float[]{0.0f, 0.0f, 0.0f};
        TransporterManager.remove(stack);
        BlockPos blockPos = new BlockPos((double)((float)tile.coord().x + pos[0]), (double)((float)tile.coord().y + pos[1]), (double)((float)tile.coord().z + pos[2]));
        Block.func_180635_a((World)tile.world(), (BlockPos)blockPos, (ItemStack)stack.itemStack);
    }

    public static float[] getStackPosition(ILogisticalTransporter tile, TransporterStack stack, float partial) {
        Direction side = stack.getSide(tile);
        float progress = ((float)stack.progress + partial) / 100.0f - 0.5f;
        return new float[]{0.5f + (float)side.func_82601_c() * progress, 0.25f + (float)side.func_96559_d() * progress, 0.5f + (float)side.func_82599_e() * progress};
    }

    public static void incrementColor(ILogisticalTransporter tile) {
        if (tile.getColor() == null) {
            tile.setColor(colors.get(0));
        } else if (colors.indexOf((Object)tile.getColor()) == colors.size() - 1) {
            tile.setColor(null);
        } else {
            int index = colors.indexOf((Object)tile.getColor());
            tile.setColor(colors.get(index + 1));
        }
    }
}

