/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tier;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.tier.BaseTier;
import mekanism.api.tier.ITier;
import mekanism.common.config.value.CachedFloatingLongValue;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public enum InductionProviderTier implements ITier
{
    BASIC(BaseTier.BASIC, FloatingLong.createConst(64000L)),
    ADVANCED(BaseTier.ADVANCED, FloatingLong.createConst(512000L)),
    ELITE(BaseTier.ELITE, FloatingLong.createConst(4096000L)),
    ULTIMATE(BaseTier.ULTIMATE, FloatingLong.createConst(32768000L));

    private final FloatingLong baseOutput;
    private final BaseTier baseTier;
    private CachedFloatingLongValue outputReference;

    private InductionProviderTier(BaseTier tier, FloatingLong out) {
        this.baseOutput = out;
        this.baseTier = tier;
    }

    @Override
    public BaseTier getBaseTier() {
        return this.baseTier;
    }

    public FloatingLong getOutput() {
        return this.outputReference == null ? this.getBaseOutput() : (FloatingLong)this.outputReference.get();
    }

    public FloatingLong getBaseOutput() {
        return this.baseOutput;
    }

    public void setConfigReference(CachedFloatingLongValue outputReference) {
        this.outputReference = outputReference;
    }
}

