/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.container.property.IntPropertyData;
import mekanism.common.network.container.property.ItemStackPropertyData;
import mekanism.common.network.container.property.PropertyData;
import net.minecraft.item.ItemStack;

public class SyncableItemStack
implements ISyncableData {
    private final Supplier<@NonNull ItemStack> getter;
    private final Consumer<@NonNull ItemStack> setter;
    @Nonnull
    private ItemStack lastKnownValue = ItemStack.field_190927_a;

    public static SyncableItemStack create(Supplier<@NonNull ItemStack> getter, Consumer<@NonNull ItemStack> setter) {
        return new SyncableItemStack(getter, setter);
    }

    private SyncableItemStack(Supplier<@NonNull ItemStack> getter, Consumer<@NonNull ItemStack> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Nonnull
    public ItemStack get() {
        return this.getter.get();
    }

    public void set(@Nonnull ItemStack value) {
        this.setter.accept(value);
    }

    public void set(int amount) {
        ItemStack stack = this.get();
        if (!stack.func_190926_b()) {
            stack.func_190920_e(amount);
        }
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        boolean sameItem;
        ItemStack value = this.get();
        boolean bl = sameItem = value.func_77969_a(this.lastKnownValue) && ItemStack.func_77970_a((ItemStack)value, (ItemStack)this.lastKnownValue);
        if (!sameItem || value.func_190916_E() != this.lastKnownValue.func_190916_E()) {
            this.lastKnownValue = value.func_77946_l();
            return sameItem ? ISyncableData.DirtyType.SIZE : ISyncableData.DirtyType.DIRTY;
        }
        return ISyncableData.DirtyType.CLEAN;
    }

    @Override
    public PropertyData getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        if (dirtyType == ISyncableData.DirtyType.SIZE) {
            return new IntPropertyData(property, this.get().func_190916_E());
        }
        return new ItemStackPropertyData(property, this.get());
    }
}

