/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.distribution.target;

import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import mekanism.common.distribution.SplitInfo;
import net.minecraft.util.Direction;

public abstract class Target<HANDLER, TYPE extends Number, EXTRA> {
    protected final Map<Direction, HANDLER> handlers = new EnumMap<Direction, HANDLER>(Direction.class);
    protected final Map<Direction, TYPE> needed = new EnumMap<Direction, TYPE>(Direction.class);
    protected EXTRA extra;

    public void addHandler(Direction side, HANDLER handler) {
        this.handlers.put(side, handler);
    }

    public Map<Direction, HANDLER> getHandlers() {
        return this.handlers;
    }

    public void sendRemainingSplit(SplitInfo<TYPE> splitInfo) {
        for (Direction side : this.needed.keySet()) {
            this.acceptAmount(this.handlers.get(side), splitInfo, splitInfo.getRemainderAmount());
        }
    }

    protected abstract void acceptAmount(HANDLER var1, SplitInfo<TYPE> var2, TYPE var3);

    protected abstract TYPE simulate(HANDLER var1, EXTRA var2);

    public void sendPossible(EXTRA toSend, SplitInfo<TYPE> splitInfo) {
        for (Map.Entry<Direction, HANDLER> entry : this.handlers.entrySet()) {
            TYPE amountNeeded = this.simulate(entry.getValue(), toSend);
            if (((Comparable)amountNeeded).compareTo(splitInfo.getShareAmount()) <= 0) {
                this.acceptAmount(entry.getValue(), splitInfo, amountNeeded);
                continue;
            }
            this.needed.put(entry.getKey(), amountNeeded);
        }
    }

    public void shiftNeeded(SplitInfo<TYPE> splitInfo) {
        Iterator<Map.Entry<Direction, TYPE>> iterator = this.needed.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Direction, TYPE> needInfo = iterator.next();
            Number amountNeeded = (Number)needInfo.getValue();
            if (((Comparable)((Object)amountNeeded)).compareTo(splitInfo.getShareAmount()) > 0) continue;
            this.acceptAmount(this.handlers.get(needInfo.getKey()), splitInfo, amountNeeded);
            iterator.remove();
        }
    }
}

