/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.distribution.target;

import javax.annotation.Nonnull;
import mekanism.api.math.MathUtils;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.distribution.SplitInfo;
import mekanism.common.distribution.target.Target;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.FluidNetwork;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTransmitterSaveTarget
extends Target<IGridTransmitter<IFluidHandler, FluidNetwork, FluidStack>, Integer, FluidStack> {
    private FluidStack currentStored = FluidStack.EMPTY;

    public FluidTransmitterSaveTarget(@Nonnull FluidStack type) {
        this.extra = type;
    }

    @Override
    protected void acceptAmount(IGridTransmitter<IFluidHandler, FluidNetwork, FluidStack> transmitter, SplitInfo<Integer> splitInfo, Integer amount) {
        amount = Math.min(amount, MathUtils.clampToInt(transmitter.getCapacity() - (long)this.currentStored.getAmount()));
        FluidStack newFluid = new FluidStack((FluidStack)this.extra, amount.intValue());
        if (this.currentStored.isEmpty()) {
            this.currentStored = newFluid;
        } else {
            this.currentStored.grow(amount.intValue());
        }
        splitInfo.send(amount);
    }

    @Override
    protected Integer simulate(IGridTransmitter<IFluidHandler, FluidNetwork, FluidStack> transmitter, @Nonnull FluidStack fluidStack) {
        if (!this.currentStored.isEmpty() && !this.currentStored.isFluidEqual(fluidStack)) {
            return 0;
        }
        return Math.min(fluidStack.getAmount(), MathUtils.clampToInt(transmitter.getCapacity() - (long)this.currentStored.getAmount()));
    }

    public void saveShare(Direction handlerDirection) {
        TileEntityTransmitter tile;
        IGridTransmitter transmitter = (IGridTransmitter)this.handlers.get(handlerDirection);
        if (transmitter instanceof TransmitterImpl && (tile = ((TransmitterImpl)transmitter).getTileEntity()) instanceof TileEntityMechanicalPipe) {
            TileEntityMechanicalPipe pipe = (TileEntityMechanicalPipe)tile;
            if (this.currentStored.isEmpty() != pipe.saveShare.isEmpty() || !this.currentStored.isEmpty() && !this.currentStored.isFluidStackIdentical(pipe.saveShare)) {
                pipe.saveShare = this.currentStored;
                pipe.markDirty(false);
            }
        }
    }
}

