/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.DataHandlerUtils;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.base.ContainerEditMode;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.InventoryMultiblockCache;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;

public class TankCache
extends InventoryMultiblockCache<SynchronizedTankData>
implements IMekanismFluidHandler {
    private final List<IExtendedFluidTank> fluidTanks = Collections.singletonList(BasicFluidTank.create(Integer.MAX_VALUE, this));
    public ContainerEditMode editMode = ContainerEditMode.BOTH;

    @Override
    public void apply(SynchronizedTankData data) {
        data.setInventoryData(this.inventorySlots);
        data.setTankData(this.fluidTanks);
        data.editMode = this.editMode;
    }

    @Override
    public void sync(SynchronizedTankData data) {
        List<IInventorySlot> slotsToCopy = data.getInventorySlots(null);
        for (int i = 0; i < slotsToCopy.size(); ++i) {
            if (i >= this.inventorySlots.size()) continue;
            ((IInventorySlot)this.inventorySlots.get(i)).setStack(slotsToCopy.get(i).getStack());
        }
        List<IExtendedFluidTank> tanksToCopy = data.getFluidTanks(null);
        for (int i = 0; i < tanksToCopy.size(); ++i) {
            if (i >= this.fluidTanks.size()) continue;
            this.fluidTanks.get(i).setStack(tanksToCopy.get(i).getFluid());
        }
        this.editMode = data.editMode;
    }

    @Override
    public void load(CompoundNBT nbtTags) {
        NBTUtils.setEnumIfPresent(nbtTags, "editMode", ContainerEditMode::byIndexStatic, mode -> {
            this.editMode = mode;
        });
        DataHandlerUtils.readSlots(this.getInventorySlots(null), nbtTags.func_150295_c("Items", 10));
        DataHandlerUtils.readTanks(this.getFluidTanks(null), nbtTags.func_150295_c("FluidTanks", 10));
    }

    @Override
    public void save(CompoundNBT nbtTags) {
        nbtTags.func_74768_a("editMode", this.editMode.ordinal());
        nbtTags.func_218657_a("Items", (INBT)DataHandlerUtils.writeSlots(this.getInventorySlots(null)));
        nbtTags.func_218657_a("FluidTanks", (INBT)DataHandlerUtils.writeTanks(this.getFluidTanks(null)));
    }

    @Override
    @Nonnull
    public List<IExtendedFluidTank> getFluidTanks(@Nullable Direction side) {
        return this.fluidTanks;
    }
}

