/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.blocktype;

import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.common.Mekanism;
import mekanism.common.base.ILangEntry;
import mekanism.common.block.attribute.AttributeEnergy;
import mekanism.common.block.attribute.AttributeGui;
import mekanism.common.block.attribute.AttributeSound;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import mekanism.common.registration.impl.TileEntityTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;

public class BlockTypeTile<TILE extends TileEntityMekanism>
extends BlockType {
    private Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar;

    public BlockTypeTile(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, ILangEntry description) {
        super(description);
        this.tileEntityRegistrar = tileEntityRegistrar;
    }

    public TileEntityType<TILE> getTileType() {
        return this.tileEntityRegistrar.get().getTileEntityType();
    }

    public static class BlockTileBuilder<BLOCK extends BlockTypeTile<TILE>, TILE extends TileEntityMekanism, T extends BlockTileBuilder<BLOCK, TILE, T>>
    extends BlockType.BlockTypeBuilder<BLOCK, T> {
        protected BlockTileBuilder(BLOCK holder) {
            super(holder);
        }

        public static <TILE extends TileEntityMekanism> BlockTileBuilder<BlockTypeTile<TILE>, TILE, ?> createBlock(Supplier<TileEntityTypeRegistryObject<TILE>> tileEntityRegistrar, ILangEntry description) {
            return new BlockTileBuilder(new BlockTypeTile<TILE>(tileEntityRegistrar, description));
        }

        public T withSound(SoundEventRegistryObject<SoundEvent> soundRegistrar) {
            return (T)((BlockTileBuilder)this.with(new AttributeSound(soundRegistrar)));
        }

        public T withGui(Supplier<ContainerTypeRegistryObject<? extends MekanismTileContainer<?>>> containerRegistrar) {
            return (T)((BlockTileBuilder)this.with(new AttributeGui(containerRegistrar)));
        }

        public T withEnergyConfig(FloatingLongSupplier energyUsage, FloatingLongSupplier energyStorage) {
            return (T)((BlockTileBuilder)this.with(new AttributeEnergy(energyUsage, energyStorage)));
        }

        public T withEnergyConfig(FloatingLongSupplier energyStorage) {
            return (T)((BlockTileBuilder)this.with(new AttributeEnergy(null, energyStorage)));
        }

        public T withCustomContainer(Function<TileEntityMekanism, INamedContainerProvider> customContainerSupplier) {
            if (!((BlockTypeTile)this.holder).has(AttributeGui.class)) {
                Mekanism.logger.error("Attempted to set a custom container on a block type without a GUI attribute.");
            }
            ((BlockTypeTile)this.holder).get(AttributeGui.class).setCustomContainer(customContainerSupplier);
            return (T)((BlockTileBuilder)this.getThis());
        }
    }
}

