/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.math.FloatingLong;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.client.ClientProxy;
import mekanism.client.ModelLoaderRegisterHelper;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.CommonPlayerTracker;
import mekanism.common.CommonProxy;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.CreativeTabMekanism;
import mekanism.common.FuelHandler;
import mekanism.common.KeySync;
import mekanism.common.MekFakePlayer;
import mekanism.common.PlayerState;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.command.CommandMek;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.frequency.FrequencyType;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketHandler;
import mekanism.common.network.PacketTransmitterUpdate;
import mekanism.common.recipe.RecipeCacheManager;
import mekanism.common.recipe.bin.BinInsertRecipe;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismContainerTypes;
import mekanism.common.registries.MekanismEntityTypes;
import mekanism.common.registries.MekanismFeatures;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismInfuseTypes;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.registries.MekanismPlacements;
import mekanism.common.registries.MekanismRecipeSerializers;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tags.MekanismTagManager;
import mekanism.common.transmitters.grid.EnergyNetwork;
import mekanism.common.transmitters.grid.FluidNetwork;
import mekanism.common.transmitters.grid.GasNetwork;
import mekanism.common.world.GenHandler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="mekanism")
public class Mekanism {
    public static final String MODID = "mekanism";
    public static final String MOD_NAME = "Mekanism";
    public static final String LOG_TAG = "[Mekanism]";
    public static final PlayerState playerState = new PlayerState();
    public static PacketHandler packetHandler = new PacketHandler();
    public static Logger logger = LogManager.getLogger((String)"Mekanism");
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> Mekanism.getClientProxy(), () -> () -> new CommonProxy());
    public static Mekanism instance;
    public static MekanismHooks hooks;
    public final Version versionNumber;
    public static MultiblockManager<SynchronizedTankData> tankManager;
    public static MultiblockManager<SynchronizedMatrixData> matrixManager;
    public static MultiblockManager<SynchronizedBoilerData> boilerManager;
    public static FrequencyManager publicTeleporters;
    public static Map<UUID, FrequencyManager> privateTeleporters;
    public static FrequencyManager publicEntangloporters;
    public static Map<UUID, FrequencyManager> privateEntangloporters;
    public static FrequencyManager securityFrequencies;
    public static CreativeTabMekanism tabMekanism;
    public static List<IModule> modulesLoaded;
    public static CommonWorldTickHandler worldTickHandler;
    public static GameProfile gameProfile;
    public static KeySync keyMap;
    public static Set<Coord4D> activeVibrators;
    private MekanismTagManager mekanismTagManager;
    private RecipeCacheManager recipeCacheManager;

    @OnlyIn(value=Dist.CLIENT)
    private static Supplier<CommonProxy> getClientProxy() {
        return ClientProxy::new;
    }

    public Mekanism() {
        instance = this;
        MekanismConfig.registerConfigs(ModLoadingContext.get());
        logger.debug("Mekanism Debug mode: {}", (Object)(MekanismAPI.debug ? "enabled" : "disabled"));
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(this::onEnergyTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::onGasTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::onLiquidTransferred);
        MinecraftForge.EVENT_BUS.addListener(this::chunkSave);
        MinecraftForge.EVENT_BUS.addListener(this::onChunkDataLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldLoad);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldUnload);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopped);
        modEventBus.addListener(this::onConfigLoad);
        modEventBus.addListener(this::imcQueue);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::serverAboutToStartLowest);
        MinecraftForge.EVENT_BUS.addListener(BinInsertRecipe::onCrafting);
        MekanismItems.ITEMS.register(modEventBus);
        MekanismBlocks.BLOCKS.register(modEventBus);
        MekanismFluids.FLUIDS.register(modEventBus);
        MekanismContainerTypes.CONTAINER_TYPES.register(modEventBus);
        MekanismEntityTypes.ENTITY_TYPES.register(modEventBus);
        MekanismTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        MekanismSounds.SOUND_EVENTS.register(modEventBus);
        MekanismParticleTypes.PARTICLE_TYPES.register(modEventBus);
        MekanismPlacements.PLACEMENTS.register(modEventBus);
        MekanismFeatures.FEATURES.register(modEventBus);
        MekanismRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        MekanismInfuseTypes.INFUSE_TYPES.register(modEventBus);
        MekanismGases.GASES.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer().getModInfo().getVersion());
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, ModelLoaderRegisterHelper::registerModelLoader);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void setTagManager(MekanismTagManager manager) {
        if (this.mekanismTagManager == null) {
            this.mekanismTagManager = manager;
        }
    }

    public MekanismTagManager getTagManager() {
        return this.mekanismTagManager;
    }

    public void setRecipeCacheManager(RecipeCacheManager manager) {
        if (this.recipeCacheManager == null) {
            this.recipeCacheManager = manager;
        }
    }

    public RecipeCacheManager getRecipeCacheManager() {
        return this.recipeCacheManager;
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        IReloadableResourceManager resourceManager = event.getServer().func_195570_aG();
        boolean added = false;
        if (resourceManager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager manager = (SimpleReloadableResourceManager)resourceManager;
            for (int i = 0; i < manager.field_199015_d.size(); ++i) {
                IFutureReloadListener listener = (IFutureReloadListener)manager.field_199015_d.get(i);
                if (!(listener instanceof NetworkTagManager)) continue;
                manager.field_199015_d.add(i + 1, this.getTagManager());
                added = true;
                break;
            }
        }
        if (!added) {
            resourceManager.func_219534_a((IFutureReloadListener)this.getTagManager());
        }
    }

    private void serverAboutToStartLowest(FMLServerAboutToStartEvent event) {
        event.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)this.getRecipeCacheManager());
    }

    private void serverStarting(FMLServerStartingEvent event) {
        event.getCommandDispatcher().register(CommandMek.register());
    }

    private void serverStopped(FMLServerStoppedEvent event) {
        playerState.clear();
        activeVibrators.clear();
        worldTickHandler.resetRegenChunks();
        privateTeleporters.clear();
        privateEntangloporters.clear();
        SynchronizedBoilerData.hotMap.clear();
        MultiblockManager.reset();
        FrequencyManager.reset();
        TransporterManager.reset();
        PathfinderCache.reset();
        TransmitterNetworkRegistry.reset();
    }

    private void imcQueue(InterModEnqueueEvent event) {
        hooks.sendIMCMessages(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        hooks.hookCommonSetup();
        Capabilities.registerCapabilities();
        FuelHandler.addGas(MekanismGases.HYDROGEN, 1, (FloatingLong)MekanismConfig.general.FROM_H2.get());
        GenHandler.setupWorldGeneration();
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTickHandler());
        logger.info("Version " + this.versionNumber + " initializing...");
        MinecraftForge.EVENT_BUS.register((Object)this);
        TransmitterNetworkRegistry.initiate();
        hooks.hookCommonSetup();
        packetHandler.initialize();
        proxy.init();
        logger.info("Fake player readout: UUID = " + gameProfile.getId().toString() + ", name = " + gameProfile.getName());
        logger.info("Loading complete.");
        logger.info("Mod loaded.");
    }

    private void onEnergyTransferred(EnergyNetwork.EnergyTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate(event.energyNetwork, event.energyScale), event.energyNetwork);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onGasTransferred(GasNetwork.GasTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate(event.gasNetwork, event.transferType, event.gasScale), event.gasNetwork);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void onLiquidTransferred(FluidNetwork.FluidTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate(event.fluidNetwork, event.fluidType, event.fluidScale), event.fluidNetwork);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void chunkSave(ChunkDataEvent.Save event) {
        if (event.getWorld() != null && !event.getWorld().func_201670_d()) {
            event.getData().func_74768_a("worldGenVersion", MekanismConfig.world.userGenVersion.get());
        }
    }

    private synchronized void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (event.getWorld() != null && !event.getWorld().func_201670_d() && MekanismConfig.world.enableRegeneration.get() && event.getData().func_74762_e("worldGenVersion") < MekanismConfig.world.userGenVersion.get()) {
            worldTickHandler.addRegenChunk(event.getWorld().func_201675_m().func_186058_p(), event.getChunk().func_76632_l());
        }
    }

    private void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            ((MekanismModConfig)config).clearCache();
        }
    }

    private void onWorldLoad(WorldEvent.Load event) {
        playerState.init(event.getWorld());
    }

    private void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            MekFakePlayer.releaseInstance(event.getWorld());
        }
    }

    static {
        hooks = new MekanismHooks();
        tankManager = new MultiblockManager("dynamicTank");
        matrixManager = new MultiblockManager("inductionMatrix");
        boilerManager = new MultiblockManager("thermoelectricBoiler");
        publicTeleporters = new FrequencyManager(FrequencyType.BASE, "Teleporter");
        privateTeleporters = new Object2ObjectOpenHashMap();
        publicEntangloporters = new FrequencyManager(FrequencyType.INVENTORY, "Entangloporter");
        privateEntangloporters = new Object2ObjectOpenHashMap();
        securityFrequencies = new FrequencyManager(FrequencyType.SECURITY, "Security");
        tabMekanism = new CreativeTabMekanism();
        modulesLoaded = new ArrayList<IModule>();
        worldTickHandler = new CommonWorldTickHandler();
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("mekanism.common".getBytes()), LOG_TAG);
        keyMap = new KeySync();
        activeVibrators = new ObjectOpenHashSet();
    }
}

