/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.providers.IBaseProvider;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.jei.NOOPDrawable;
import mekanism.client.jei.chemical.ChemicalStackRenderer;
import mekanism.client.jei.chemical.GasStackRenderer;
import mekanism.client.jei.chemical.InfusionStackRenderer;
import mekanism.common.Mekanism;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class BaseRecipeCategory<RECIPE>
implements IRecipeCategory<RECIPE>,
IGuiWrapper {
    private IGuiHelper guiHelper;
    protected ITickTimer timer;
    protected int xOffset;
    protected int yOffset;
    protected IDrawable fluidOverlayLarge;
    protected IDrawable fluidOverlaySmall;
    protected Set<GuiTexturedElement> guiElements = new ObjectOpenHashSet();
    private IBaseProvider provider;
    private final IDrawable background;

    protected BaseRecipeCategory(IGuiHelper helper, IBaseProvider provider, int xOffset, int yOffset, int width, int height) {
        this.guiHelper = helper;
        this.provider = provider;
        this.timer = helper.createTickTimer(20, 20, false);
        this.fluidOverlayLarge = this.createDrawable(this.guiHelper, GaugeOverlay.STANDARD);
        this.fluidOverlaySmall = this.createDrawable(this.guiHelper, GaugeOverlay.SMALL);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.background = new NOOPDrawable(width, height);
        this.addGuiElements();
    }

    private IDrawable createDrawable(IGuiHelper helper, GaugeOverlay gaugeOverlay) {
        return helper.drawableBuilder(gaugeOverlay.getBarOverlay(), 0, 0, gaugeOverlay.getWidth(), gaugeOverlay.getHeight()).setTextureSize(gaugeOverlay.getWidth(), gaugeOverlay.getHeight()).build();
    }

    @Override
    public int getLeft() {
        return -this.xOffset;
    }

    @Override
    public int getTop() {
        return -this.yOffset;
    }

    @Override
    public int getWidth() {
        return this.background.getWidth();
    }

    @Override
    public int getHeight() {
        return this.background.getHeight();
    }

    public ResourceLocation getUid() {
        return this.provider.getRegistryName();
    }

    public String getTitle() {
        return this.provider.getTextComponent().func_150254_d();
    }

    public void draw(RECIPE recipe, double mouseX, double mouseY) {
        this.guiElements.forEach(e -> e.render((int)mouseX, (int)mouseY, 0.0f));
    }

    @Override
    public void renderItem(@Nonnull ItemStack stack, int xAxis, int yAxis, float scale) {
        if (!stack.func_190926_b()) {
            try {
                RenderSystem.pushMatrix();
                RenderSystem.enableDepthTest();
                RenderHelper.func_227780_a_();
                if (scale != 1.0f) {
                    RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                }
                Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, xAxis, yAxis);
                RenderHelper.func_74518_a();
                RenderSystem.disableDepthTest();
                RenderSystem.popMatrix();
            }
            catch (Exception e) {
                Mekanism.logger.error("Failed to render stack into gui: " + stack, (Throwable)e);
            }
        }
    }

    @Override
    public FontRenderer getFont() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    protected void addGuiElements() {
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    protected void initInfusion(IGuiIngredientGroup<@NonNull InfusionStack> group, int slot, boolean input, int x, int y, int width, int height, @Nonnull List<InfusionStack> stacks) {
        this.initChemical(group, slot, input, x, y, width, height, stacks, max -> new InfusionStackRenderer(max, width, height));
    }

    protected void initGas(IGuiIngredientGroup<@NonNull GasStack> group, int slot, boolean input, int x, int y, int width, int height, @Nonnull List<GasStack> stacks, boolean overlay) {
        this.initChemical(group, slot, input, x, y, width, height, stacks, max -> new GasStackRenderer(max, false, width, height, overlay ? (height > 50 ? this.fluidOverlayLarge : this.fluidOverlaySmall) : null));
    }

    protected <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void initChemical(IGuiIngredientGroup<@NonNull STACK> group, int slot, boolean input, int x, int y, int width, int height, @Nonnull List<STACK> stacks, Long2ObjectFunction<ChemicalStackRenderer<CHEMICAL, STACK>> rendererSupplier) {
        if (stacks.isEmpty()) {
            return;
        }
        long max = stacks.stream().mapToLong(ChemicalStack::getAmount).filter(stack -> stack >= 0L).max().orElse(0L);
        group.init(slot, input, (IIngredientRenderer)rendererSupplier.apply(max), x, y, width, height, 0, 0);
        group.set(slot, stacks);
    }
}

