/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import net.minecraft.client.Minecraft;

public class MekanismButton
extends GuiElement {
    private final GuiElement.IHoverable onHover;
    private final Runnable onLeftClick;
    private final Runnable onRightClick;

    public MekanismButton(IGuiWrapper gui, int x, int y, int width, int height, String text, Runnable onLeftClick, GuiElement.IHoverable onHover) {
        this(gui, x, y, width, height, text, onLeftClick, onLeftClick, onHover);
    }

    public MekanismButton(IGuiWrapper gui, int x, int y, int width, int height, String text, Runnable onLeftClick, Runnable onRightClick, GuiElement.IHoverable onHover) {
        super(gui, x, y, width, height, text);
        this.onHover = onHover;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
        this.playClickSound = true;
    }

    private void onLeftClick() {
        if (this.onLeftClick != null) {
            this.onLeftClick.run();
        }
    }

    public void onClick(double mouseX, double mouseY) {
        this.onLeftClick();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.active && this.visible && (keyCode == 257 || keyCode == 32 || keyCode == 335)) {
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onLeftClick();
            return true;
        }
        return false;
    }

    public void renderToolTip(int mouseX, int mouseY) {
        if (this.onHover != null) {
            this.onHover.onHover(this, mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.active && this.visible && this.isHovered() && button == 1) {
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onRightClick();
            return true;
        }
        return false;
    }

    protected void onRightClick() {
        if (this.onRightClick != null) {
            this.onRightClick.run();
        }
    }
}

