/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import mekanism.api.energy.IEnergyContainer;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiHorizontalPowerBar
extends GuiBar<GuiBar.IBarInfoHandler> {
    private static final ResourceLocation ENERGY_BAR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "horizontal_power.png");
    private static final int texWidth = 52;
    private static final int texHeight = 4;
    private final double widthScale;

    public GuiHorizontalPowerBar(IGuiWrapper gui, IEnergyContainer container, int x, int y) {
        this(gui, container, x, y, 52);
    }

    public GuiHorizontalPowerBar(IGuiWrapper gui, final IEnergyContainer container, int x, int y, int desiredWidth) {
        this(gui, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return EnergyDisplay.of(container.getEnergy(), container.getMaxEnergy()).getTextComponent();
            }

            @Override
            public double getLevel() {
                return container.getEnergy().divideToLevel(container.getMaxEnergy());
            }
        }, x, y, desiredWidth);
    }

    public GuiHorizontalPowerBar(IGuiWrapper gui, GuiBar.IBarInfoHandler handler, int x, int y, int desiredWidth) {
        super(ENERGY_BAR, gui, handler, x, y, desiredWidth, 4);
        this.widthScale = (double)desiredWidth / 52.0;
    }

    @Override
    protected void renderBarOverlay(int mouseX, int mouseY, float partialTicks) {
        int displayInt = (int)(this.getHandler().getLevel() * 52.0);
        GuiHorizontalPowerBar.blit((int)(this.x + 1), (int)(this.y + 1), (int)GuiHorizontalPowerBar.calculateScaled(this.widthScale, displayInt), (int)4, (float)0.0f, (float)0.0f, (int)displayInt, (int)4, (int)52, (int)4);
    }
}

