/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.scroll.GuiTextScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.sound.SoundHandler;
import mekanism.common.MekanismLang;
import mekanism.common.TagCache;
import mekanism.common.inventory.container.item.DictionaryContainer;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.StackUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;

public class GuiDictionary
extends GuiMekanism<DictionaryContainer> {
    private ItemStack itemType = ItemStack.field_190927_a;
    private GuiTextScrollList scrollList;

    public GuiDictionary(DictionaryContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 5, 5).setRenderHover(true));
        this.scrollList = new GuiTextScrollList(this, 7, 29, 162, 42);
        this.addButton(this.scrollList);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(MekanismItems.DICTIONARY.getTextComponent(), 64, 5, 0x404040);
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 2, 0x404040);
        this.renderItem(this.itemType, 6, 6);
        super.func_146979_b(mouseX, mouseY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        double xAxis = mouseX - (double)this.getGuiLeft();
        double yAxis = mouseY - (double)this.getGuiTop();
        if (button == 0) {
            if (GuiDictionary.hasShiftDown()) {
                ItemStack stack;
                Slot hovering = null;
                for (int i = 0; i < ((DictionaryContainer)this.field_147002_h).field_75151_b.size(); ++i) {
                    Slot slot = (Slot)((DictionaryContainer)this.field_147002_h).field_75151_b.get(i);
                    if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
                    hovering = slot;
                    break;
                }
                if (hovering != null && !(stack = hovering.func_75211_c()).func_190926_b()) {
                    this.itemType = StackUtils.size(stack, 1);
                    this.scrollList.setText(TagCache.getItemTags(this.itemType));
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                    return true;
                }
            }
            if (xAxis >= 6.0 && xAxis <= 22.0 && yAxis >= 6.0 && yAxis <= 22.0) {
                ItemStack stack = this.minecraft.field_71439_g.field_71071_by.func_70445_o();
                if (!stack.func_190926_b() && !GuiDictionary.hasShiftDown()) {
                    this.itemType = StackUtils.size(stack, 1);
                    this.scrollList.setText(TagCache.getItemTags(this.itemType));
                } else if (stack.func_190926_b() && GuiDictionary.hasShiftDown()) {
                    this.itemType = ItemStack.field_190927_a;
                    this.scrollList.setText(null);
                }
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

