/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.RevertedPacket;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ReversionEyesPotion
extends EyesPotion {
    public ReversionEyesPotion() {
        super(ModEffects.getColorNumber(242, 7, 23));
        EffectUtil.effectIcon = new ResourceLocation("mahoutsukai", "textures/effects/reverted.png");
    }

    public static void reversionEyesPlayerTick(PlayerEntity player) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.REVERSION_EYES)) {
            ReversionEyesPotion.addRevert((LivingEntity)player);
        }
    }

    public static void reversionEyesLivingUpdate(LivingEntity entity) {
        World world = entity.field_70170_p;
        if (!world.field_72995_K && ReversionEyesPotion.isEntityReverted(entity)) {
            ReversionEyesPotion.cantBreatheUnderwater(entity);
            ReversionEyesPotion.canBurn(entity);
            ReversionEyesPotion.burnInDay(entity);
            ReversionEyesPotion.noMoreEffects(entity);
            if (!ReversionEyesPotion.continueReverting(entity)) {
                EffectUtil.debuff(entity, ModEffects.REVERTED);
                ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
                lst.add(entity);
            }
        }
    }

    public static boolean continueReverting(LivingEntity victim) {
        int totalRange = MTConfig.REVERSION_EYES_RANGE_FROM_USER;
        Vec3d myloc = new Vec3d(victim.func_226277_ct_(), victim.func_226278_cu_(), victim.func_226281_cx_());
        boolean keepReverting = false;
        List lst = victim.field_70170_p.func_217357_a(PlayerEntity.class, new AxisAlignedBB(victim.func_226277_ct_() - (double)totalRange, victim.func_226278_cu_() - (double)totalRange, victim.func_226281_cx_() - (double)totalRange, victim.func_226277_ct_() + (double)totalRange, victim.func_226278_cu_() + (double)totalRange, victim.func_226281_cx_() + (double)totalRange));
        for (PlayerEntity tmp : lst) {
            if (tmp.func_110124_au().equals(victim.func_110124_au()) || !EffectUtil.hasBuff((LivingEntity)tmp, ModEffects.REVERSION_EYES) || !EffectUtil.inRange(victim, (LivingEntity)tmp, myloc, MTConfig.REVERSION_EYES_RANGE_FROM_LOOK_VEC, false)) continue;
            keepReverting = true;
        }
        return keepReverting;
    }

    public static void addRevert(LivingEntity target) {
        int totalRange = MTConfig.REVERSION_EYES_RANGE_FROM_USER;
        Vec3d myloc = new Vec3d(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        List lst = target.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(target.func_226277_ct_() - (double)totalRange, target.func_226278_cu_() - (double)totalRange, target.func_226281_cx_() - (double)totalRange, target.func_226277_ct_() + (double)totalRange, target.func_226278_cu_() + (double)totalRange, target.func_226281_cx_() + (double)totalRange));
        ArrayList<LivingEntity> toSendE = new ArrayList<LivingEntity>();
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, target, myloc, MTConfig.REVERSION_EYES_RANGE_FROM_LOOK_VEC, false) || ContractMahoujinTileEntity.isImmuneToSpell(target.field_70170_p, target.func_110124_au(), (Entity)tmp) || ReversionEyesPotion.isEntityReverted(tmp)) continue;
            ReversionEyesPotion.setEntityReverted(tmp);
            toSendE.add(tmp);
        }
        ReversionEyesPotion.notifyTracking(toSendE, true, target.field_70170_p);
    }

    public static void setEntityReverted(LivingEntity target) {
        EffectUtil.buff(target, ModEffects.REVERTED, false, 100);
    }

    public static boolean isEntityReverted(LivingEntity target) {
        return EffectUtil.hasBuff(target, ModEffects.REVERTED);
    }

    public static void noMoreEffects(LivingEntity e) {
        if (!e.field_70170_p.field_72995_K) {
            ArrayList<Effect> toremove = new ArrayList<Effect>();
            for (EffectInstance effect : e.func_70651_bq()) {
                if (effect.func_188419_a() == ModEffects.REVERTED) continue;
                toremove.add(effect.func_188419_a());
            }
            for (Effect p : toremove) {
                try {
                    e.func_195063_d(p);
                }
                catch (Exception exception) {}
            }
            IMahou mahou = Utils.getPlayerMahou(e);
            if (mahou != null) {
                mahou.clearBuffs();
            }
        } else {
            MahouTsukaiMod.proxy.revertPlayer();
        }
    }

    public static boolean reversionEyesProjectileImpact(Entity entity, RayTraceResult r) {
        Entity target;
        boolean ret = false;
        if (entity != null && r instanceof EntityRayTraceResult && (target = ((EntityRayTraceResult)r).func_216348_a()) instanceof LivingEntity && ReversionEyesPotion.isEntityReverted((LivingEntity)target)) {
            ret = true;
            if (entity instanceof ArrowEntity) {
                ReversionEyesPotion.arrowEnderman(target, (ArrowEntity)entity);
            }
        }
        return ret;
    }

    public static void arrowEnderman(Entity entity, ArrowEntity arrow) {
        if (entity != null) {
            Vec3d arrowmot = arrow.func_213322_ci();
            double motionX = arrowmot.field_72450_a;
            double motionY = arrowmot.field_72448_b;
            double motionZ = arrowmot.field_72449_c;
            float f = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
            int i = MathHelper.func_76143_f((double)((double)f * arrow.func_70242_d()));
            if (arrow.func_70241_g()) {
                i += entity.field_70170_p.field_73012_v.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = arrow.field_70250_c == null ? DamageSource.func_76353_a((AbstractArrowEntity)arrow, (Entity)arrow) : DamageSource.func_76353_a((AbstractArrowEntity)arrow, null);
            if (arrow.func_70027_ad()) {
                entity.func_70015_d(5);
            }
            if (entity instanceof EndermanEntity) {
                if (ReversionEyesPotion.attackEntityFrom((LivingEntity)entity, DamageSource.field_76377_j, i)) {
                    float f1;
                    LivingEntity LivingEntity2 = (LivingEntity)entity;
                    if (!arrow.field_70170_p.field_72995_K) {
                        LivingEntity2.func_85034_r(LivingEntity2.func_85035_bI() + 1);
                    }
                    if ((f1 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ))) > 0.0f) {
                        LivingEntity2.func_70024_g(motionX * 3.0 * (double)0.6f / (double)f1, 0.1, motionZ * 3.0 * (double)0.6f / (double)f1);
                    }
                    arrow.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (arrow.field_70170_p.field_73012_v.nextFloat() * 0.2f + 0.9f));
                    arrow.func_70106_y();
                }
                return;
            }
            if (entity instanceof LivingEntity && !entity.func_70097_a(damagesource, (float)i)) {
                ReversionEyesPotion.attackEntityFrom((LivingEntity)entity, DamageSource.field_76377_j, i);
                LivingEntity LivingEntity3 = (LivingEntity)entity;
                if (!arrow.field_70170_p.field_72995_K) {
                    LivingEntity3.func_85034_r(LivingEntity3.func_85035_bI() + 1);
                }
                float f1 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
                arrow.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (arrow.field_70170_p.field_73012_v.nextFloat() * 0.2f + 0.9f));
                arrow.func_70106_y();
            }
        }
    }

    public static void notifyIfReverted(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (ReversionEyesPotion.isEntityReverted(e)) {
            ReversionEyesPotion.notifyTracking(lst, true, e.field_70170_p);
        }
    }

    public static void notifyNotReverted(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        ReversionEyesPotion.notifyTracking(lst, false, e.field_70170_p);
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, World world) {
        if (world instanceof ServerWorld) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new RevertedPacket(e.func_145782_y(), r));
            }
        }
    }

    public static boolean attackEntityFrom(LivingEntity e, DamageSource source, float amount) {
        Entity entity1;
        boolean flag1 = false;
        if (e.field_70170_p.field_72995_K) {
            return false;
        }
        if (e.func_110143_aJ() <= 0.0f) {
            return false;
        }
        float f = amount;
        e.field_70721_aZ = 1.5f;
        float f2 = e.field_70172_ad;
        e.getClass();
        if (f2 > 20.0f / 2.0f) {
            ReversionEyesPotion.damageEntity(e, source, amount);
            flag1 = true;
        } else {
            e.getClass();
            e.field_70172_ad = 20;
            ReversionEyesPotion.damageEntity(e, source, amount);
            e.field_70737_aN = e.field_70738_aO = 10;
        }
        e.field_70739_aP = 0.0f;
        Entity entity12 = source.func_76346_g();
        if (entity12 != null && entity12 instanceof LivingEntity) {
            e.func_70604_c((LivingEntity)entity12);
        }
        byte b0 = 2;
        e.field_70170_p.func_72960_a((Entity)e, b0);
        if (source != DamageSource.field_76369_e && amount > 0.0f) {
            e.field_70133_I = true;
        }
        if ((entity1 = source.func_76346_g()) != null) {
            double d1 = entity1.func_226277_ct_() - e.func_226277_ct_();
            double d0 = entity1.func_226281_cx_() - e.func_226281_cx_();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            e.field_70739_aP = (float)(MathHelper.func_181159_b((double)d0, (double)d1) * 57.29577951308232 - (double)e.field_70177_z);
            e.func_70653_a(entity1, 0.4f, d1, d0);
        } else {
            e.field_70739_aP = (int)(Math.random() * 2.0) * 180;
        }
        if (flag1) {
            if (e instanceof EndermanEntity) {
                e.func_184185_a(SoundEvents.field_187531_aU, 1.0f, ReversionEyesPotion.getSoundPitch(e));
            }
            if (e instanceof ShulkerEntity) {
                e.func_184185_a(SoundEvents.field_187783_eT, 1.0f, ReversionEyesPotion.getSoundPitch(e));
            }
        }
        return true;
    }

    public static float getSoundPitch(LivingEntity e) {
        return e.func_70631_g_() ? (e.field_70170_p.field_73012_v.nextFloat() - e.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.5f : (e.field_70170_p.field_73012_v.nextFloat() - e.field_70170_p.field_73012_v.nextFloat()) * 0.2f + 1.0f;
    }

    public static void damageEntity(LivingEntity e, DamageSource damageSrc, float damageAmount) {
        if (!e.func_190530_aW()) {
            if ((damageAmount = ForgeHooks.onLivingHurt((LivingEntity)e, (DamageSource)damageSrc, (float)damageAmount)) <= 0.0f) {
                return;
            }
            float f = damageAmount;
            damageAmount = Math.max(damageAmount - e.func_110139_bj(), 0.0f);
            e.func_110149_m(e.func_110139_bj() - (f - damageAmount));
            damageAmount = ForgeHooks.onLivingDamage((LivingEntity)e, (DamageSource)damageSrc, (float)damageAmount);
            if (damageAmount != 0.0f) {
                float f1 = e.func_110143_aJ();
                e.func_110142_aN().func_94547_a(damageSrc, f1, damageAmount);
                e.func_70606_j(f1 - damageAmount);
                e.func_110149_m(e.func_110139_bj() - damageAmount);
            }
        }
    }

    public static void canBurn(LivingEntity e) {
        if (e.func_70045_F()) {
            if (e.func_180799_ab()) {
                e.func_70097_a(DamageSource.field_76371_c, 4.0f);
                e.func_70015_d(15);
            }
            if (e.field_70170_p.func_147470_e(e.func_174813_aQ().func_186664_h(0.001))) {
                e.func_70097_a(DamageSource.field_76372_a, 1.0f);
            }
        }
    }

    public static void burnInDay(LivingEntity e) {
        float f;
        if (e instanceof HuskEntity && (f = e.func_70013_c()) > 0.5f && e.field_70170_p.field_73012_v.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && e.field_70170_p.func_226660_f_(new BlockPos(e.func_226277_ct_(), e.func_226278_cu_() + (double)e.func_70047_e(), e.func_226281_cx_()))) {
            boolean flag = true;
            ItemStack itemstack = e.func_184582_a(EquipmentSlotType.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_196085_b(itemstack.func_77952_i() + e.field_70170_p.field_73012_v.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        e.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                e.func_70015_d(8);
            }
        }
    }

    public static void cantBreatheUnderwater(LivingEntity e) {
        if (e.func_70090_H()) {
            if (e instanceof WaterMobEntity) {
                e.func_70050_g(-20);
            }
            if (e.func_70648_aU() || e.func_70644_a(Effects.field_76427_o)) {
                e.func_70050_g(ReversionEyesPotion.decreaseAirSupply(e, e.func_70086_ai()));
                if (e.func_70086_ai() <= 0 && e.field_70170_p.func_72820_D() % 20L == 0L) {
                    e.func_70050_g(0);
                    for (int i = 0; i < 8; ++i) {
                        float f2 = e.func_70681_au().nextFloat() - e.func_70681_au().nextFloat();
                        float f = e.func_70681_au().nextFloat() - e.func_70681_au().nextFloat();
                        float f1 = e.func_70681_au().nextFloat() - e.func_70681_au().nextFloat();
                        e.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, e.func_226277_ct_() + (double)f2, e.func_226278_cu_() + (double)f, e.func_226281_cx_() + (double)f1, e.func_213322_ci().field_72450_a, e.func_213322_ci().field_72448_b, e.func_213322_ci().field_72449_c);
                    }
                    e.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            }
        }
    }

    public static int decreaseAirSupply(LivingEntity e, int air) {
        int i = EnchantmentHelper.func_185292_c((LivingEntity)e);
        return i > 0 && e.func_70681_au().nextInt(i + 1) > 0 ? air : air - 1;
    }
}

