/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class RevertedPacket {
    int entityids;
    boolean reverted;

    public RevertedPacket() {
    }

    public RevertedPacket(int e, boolean b) {
        this.entityids = e;
        this.reverted = b;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityids = buf.readInt();
        this.reverted = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityids);
        buf.writeBoolean(this.reverted);
    }

    public static void encode(RevertedPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static RevertedPacket decode(PacketBuffer buf) {
        RevertedPacket msg = new RevertedPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(RevertedPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.updateReverted(message);
        context.get().setPacketHandled(true);
    }
}

