/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class GardenPacket {
    public double posX;
    public double posY;
    public double posZ;

    public GardenPacket() {
    }

    public GardenPacket(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static void encode(GardenPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static GardenPacket decode(PacketBuffer buf) {
        GardenPacket msg = new GardenPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(GardenPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.gardenHandler(message);
        context.get().setPacketHandled(true);
    }
}

