/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.mui.element;

import icyllis.modernui.gui.master.Canvas;
import icyllis.modernui.gui.master.IDrawable;
import javax.annotation.Nonnull;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.client.gui.ScreenUtils;
import sonar.fluxnetworks.client.mui.module.NavigationHome;

public class FluxBackground
implements IDrawable {
    private final NavigationHome module;
    private float x1;
    private float x2;
    private float y1;
    private float y2;
    private float r;
    private float g;
    private float b;

    public FluxBackground(NavigationHome module) {
        this.module = module;
        this.updateFrameColor();
    }

    public void draw(@Nonnull Canvas canvas, float v) {
        canvas.setRGBA(0.0f, 0.0f, 0.0f, 0.5f);
        canvas.drawRoundedRect(this.x1, this.y1, this.x2, this.y2, 5.0f);
        canvas.setRGBA(this.r, this.g, this.b, 1.0f);
        canvas.drawRoundedRectFrame(this.x1, this.y1, this.x2, this.y2, 5.0f);
    }

    public void resize(int width, int height) {
        this.x1 = (float)width / 2.0f - 85.0f;
        this.x2 = (float)width / 2.0f + 85.0f;
        this.y1 = (float)height / 2.0f - 77.0f;
        this.y2 = (float)height / 2.0f + 93.0f;
    }

    public void tick(int ticks) {
        if ((ticks & 0xF) == 0) {
            this.updateFrameColor();
        }
    }

    private void updateFrameColor() {
        int color = this.module.getNetwork().getSetting(NetworkSettings.NETWORK_COLOR);
        this.r = ScreenUtils.getRed(color);
        this.g = ScreenUtils.getGreen(color);
        this.b = ScreenUtils.getBlue(color);
    }
}

