/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energycell;

import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import owmii.lib.block.TileBase;
import owmii.lib.energy.SideConfig;
import owmii.lib.util.IVariant;
import owmii.powah.block.ITiles;
import owmii.powah.block.Tier;
import owmii.powah.block.energycell.EnergyCellBlock;

public class EnergyCellTile
extends TileBase.EnergyStorage<Tier, EnergyCellBlock> {
    public EnergyCellTile(Tier tier) {
        super(ITiles.ENERGY_CELL, (IVariant)tier);
    }

    public EnergyCellTile() {
        this(Tier.BASIC);
    }

    protected void onFirstTick(World world) {
        super.onFirstTick(world);
        if (this.isCreative()) {
            this.energy.setStored(this.defaultEnergyCapacity());
        }
    }

    public long extractEnergy(int maxExtract, boolean simulate, @Nullable Direction side) {
        return super.extractEnergy(maxExtract, this.isCreative(), side);
    }

    protected boolean doEnergyTransfer() {
        return this.checkRedstone();
    }

    public int getChargingSlots() {
        return 2;
    }

    public boolean keepEnergy() {
        return !this.isCreative();
    }

    public SideConfig.Type getTransferType() {
        return this.isCreative() ? SideConfig.Type.OUT : super.getTransferType();
    }

    public boolean isCreative() {
        return ((Tier)this.getVariant()).equals((Object)Tier.CREATIVE);
    }
}

