/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui.elements;

import mcjty.lostcities.config.Configuration;
import mcjty.lostcities.gui.GuiLCConfig;
import mcjty.lostcities.gui.elements.ButtonExt;
import mcjty.lostcities.gui.elements.GuiElement;

public class BooleanElement
extends GuiElement {
    private final GuiLCConfig gui;
    private String label = null;
    private final ButtonExt field;
    private final String attribute;

    public BooleanElement(final GuiLCConfig gui, String page, int x, int y, final String attribute) {
        super(page, x, y);
        this.gui = gui;
        this.attribute = attribute;
        Boolean c = gui.getLocalSetup().get().map(h -> (Boolean)h.toConfiguration().get(attribute)).orElse(false);
        this.field = new ButtonExt(gui, x, y, 60, 16, c != false ? "On" : "Off", button -> {
            String message = button.getMessage();
            if ("On".equals(message)) {
                button.setMessage("Off");
            } else {
                button.setMessage("On");
            }
            gui.getLocalSetup().get().ifPresent(profile -> {
                Configuration configuration = profile.toConfiguration();
                configuration.set(attribute, "On".equals(button.getMessage()));
                profile.copyFromConfiguration(configuration);
                gui.refreshPreview();
            });
        }){

            @Override
            public void renderToolTip(int x, int y) {
                gui.getLocalSetup().get().ifPresent(h -> gui.renderTooltip(h.toConfiguration().getValue(attribute).getComment(), x, y));
            }
        };
        gui.addWidget(this.field);
    }

    public BooleanElement label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public void render() {
        if (this.label != null && this.field.visible) {
            this.gui.drawString(this.gui.getFont(), this.label, 10, this.y + 5, -1);
        }
    }

    @Override
    public void update() {
        this.gui.getLocalSetup().get().ifPresent(profile -> {
            Boolean result = (Boolean)profile.toConfiguration().get(this.attribute);
            this.field.setMessage(result != false ? "On" : "Off");
        });
    }

    @Override
    public void setEnabled(boolean b) {
        this.field.active = b;
    }

    @Override
    public void setBasedOnMode(String mode) {
        this.field.visible = this.page.equalsIgnoreCase(mode);
    }
}

