/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.repack.registrate.builders;

import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.AbstractBuilder;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.providers.ProviderType;
import com.simibubi.create.repack.registrate.providers.loot.RegistrateEntityLootTables;
import com.simibubi.create.repack.registrate.providers.loot.RegistrateLootTableProvider;
import com.simibubi.create.repack.registrate.util.LazySpawnEggItem;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;

public class EntityBuilder<T extends Entity, P>
extends AbstractBuilder<EntityType<?>, EntityType<T>, P, EntityBuilder<T, P>> {
    private final NonNullSupplier<EntityType.Builder<T>> builder;
    private NonNullConsumer<EntityType.Builder<T>> builderCallback = $ -> {};
    @Nullable
    private ItemBuilder<LazySpawnEggItem<T>, EntityBuilder<T, P>> spawnEggBuilder;

    public static <T extends Entity, P> EntityBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.IFactory<T> factory, EntityClassification classification) {
        return new EntityBuilder<T, P>(owner, parent, name, callback, factory, classification).defaultLang();
    }

    protected EntityBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, EntityType.IFactory<T> factory, EntityClassification classification) {
        super(owner, parent, name, callback, EntityType.class);
        this.builder = () -> EntityType.Builder.func_220322_a((EntityType.IFactory)factory, (EntityClassification)classification);
    }

    public EntityBuilder<T, P> properties(NonNullConsumer<EntityType.Builder<T>> cons) {
        this.builderCallback = this.builderCallback.andThen(cons);
        return this;
    }

    @Deprecated
    public EntityBuilder<T, P> defaultSpawnEgg(int primaryColor, int secondaryColor) {
        return (EntityBuilder)this.spawnEgg(primaryColor, secondaryColor).build();
    }

    @Deprecated
    public ItemBuilder<? extends SpawnEggItem, EntityBuilder<T, P>> spawnEgg(int primaryColor, int secondaryColor) {
        ItemBuilder<LazySpawnEggItem, EntityBuilder<T, P>> ret = this.getOwner().item(this, this.getName() + "_spawn_egg", p -> new LazySpawnEggItem(this, primaryColor, secondaryColor, (Item.Properties)p)).properties(p -> p.func_200916_a(ItemGroup.field_78026_f)).model((ctx, prov) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)prov.withExistingParent(ctx.getName(), new ResourceLocation("item/template_spawn_egg"));
        });
        if (this.spawnEggBuilder == null) {
            this.onRegister(this::injectSpawnEggType);
        }
        this.spawnEggBuilder = ret;
        return ret;
    }

    public EntityBuilder<T, P> defaultLang() {
        return (EntityBuilder)this.lang(EntityType::func_210760_d);
    }

    public EntityBuilder<T, P> lang(String name) {
        return (EntityBuilder)this.lang(EntityType::func_210760_d, name);
    }

    public EntityBuilder<T, P> loot(NonNullBiConsumer<RegistrateEntityLootTables, EntityType<T>> cons) {
        return (EntityBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.ENTITY, tb -> cons.accept((RegistrateEntityLootTables)tb, (EntityType)ctx.getEntry())));
    }

    public EntityBuilder<T, P> tag(Tag<EntityType<?>> tag) {
        return (EntityBuilder)this.tag(ProviderType.ENTITY_TAGS, tag);
    }

    @Override
    protected EntityType<T> createEntry() {
        EntityType.Builder<T> builder = this.builder.get();
        this.builderCallback.accept(builder);
        return builder.func_206830_a(this.getName());
    }

    protected void injectSpawnEggType(EntityType<T> entry) {
        ItemBuilder<LazySpawnEggItem<T>, EntityBuilder<T, P>> spawnEggBuilder = this.spawnEggBuilder;
        if (spawnEggBuilder != null) {
            ((LazySpawnEggItem)((Object)spawnEggBuilder.get())).injectType();
        }
    }
}

