/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.repack.registrate.builders;

import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.AbstractBuilder;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.util.nullness.NonNullConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import com.simibubi.create.repack.registrate.util.nullness.NonNullUnaryOperator;
import com.simibubi.create.repack.registrate.util.nullness.NonnullType;
import java.util.EnumSet;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class BiomeBuilder<T extends Biome, P>
extends AbstractBuilder<Biome, T, P, BiomeBuilder<T, P>> {
    private final NonNullFunction<Biome.Builder, T> factory;
    private NonNullSupplier<Biome.Builder> initialProperties = Biome.Builder::new;
    private NonNullFunction<Biome.Builder, Biome.Builder> propertiesCallback = NonNullUnaryOperator.identity();
    private final EnumSet<BiomeManager.BiomeType> configuredTypes = EnumSet.noneOf(BiomeManager.BiomeType.class);

    public static <T extends Biome, P> BiomeBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Biome.Builder, T> factory) {
        return new BiomeBuilder<T, P>(owner, parent, name, callback, factory).defaultLang();
    }

    protected BiomeBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Biome.Builder, T> factory) {
        super(owner, parent, name, callback, Biome.class);
        this.factory = factory;
    }

    public BiomeBuilder<T, P> properties(NonNullUnaryOperator<Biome.Builder> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public BiomeBuilder<T, P> initialProperties(NonNullSupplier<Biome.Builder> properties) {
        this.initialProperties = properties;
        return this;
    }

    public BiomeBuilder<T, P> typeWeight(BiomeManager.BiomeType type, int weight) {
        if (!this.configuredTypes.add(type)) {
            throw new IllegalArgumentException("Cannot set a type weight more than once.");
        }
        this.onRegister(b -> BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(b, weight)));
        return this;
    }

    public BiomeBuilder<T, P> addDictionaryTypes(BiomeDictionary.Type ... types) {
        this.onRegister(b -> BiomeDictionary.addTypes((Biome)b, (BiomeDictionary.Type[])types));
        return this;
    }

    public BiomeBuilder<T, P> forceAutomaticDictionaryTypes() {
        this.onRegister(BiomeDictionary::makeBestGuess);
        return this;
    }

    public BiomeBuilder<T, P> addFeatures(NonNullConsumer<? super T> action) {
        this.onRegisterAfter(Feature.class, action);
        return this;
    }

    public BiomeBuilder<T, P> addCarvers(NonNullConsumer<? super T> action) {
        this.onRegisterAfter(WorldCarver.class, action);
        return this;
    }

    public BiomeBuilder<T, P> addSpawns(NonNullConsumer<? super T> action) {
        this.onRegisterAfter(EntityType.class, action);
        return this;
    }

    public BiomeBuilder<T, P> defaultLang() {
        return (BiomeBuilder)this.lang(Biome::func_210773_k);
    }

    public BiomeBuilder<T, P> lang(String name) {
        return (BiomeBuilder)this.lang(Biome::func_210773_k, name);
    }

    @Override
    @NonnullType
    protected T createEntry() {
        Biome.Builder properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Biome)this.factory.apply(properties));
    }
}

