/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.IBehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringCountUpdatePacket;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class FilteringBehaviour
extends TileEntityBehaviour {
    public static IBehaviourType<FilteringBehaviour> TYPE = new IBehaviourType<FilteringBehaviour>(){};
    ValueBoxTransform slotPositioning;
    boolean showCount;
    Vec3d textShift;
    private ItemStack filter = ItemStack.field_190927_a;
    public int count;
    private Consumer<ItemStack> callback;
    private Supplier<Boolean> isActive;
    int scrollableValue;
    int ticksUntilScrollPacket;
    boolean forceClientState;

    public FilteringBehaviour(SmartTileEntity te, ValueBoxTransform slot) {
        super(te);
        this.slotPositioning = slot;
        this.showCount = false;
        this.callback = stack -> {};
        this.isActive = () -> true;
        this.textShift = Vec3d.field_186680_a;
        this.count = 0;
        this.ticksUntilScrollPacket = -1;
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        nbt.func_218657_a("Filter", (INBT)this.getFilter().serializeNBT());
        nbt.func_74768_a("FilterAmount", this.count);
        super.writeNBT(nbt);
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        this.filter = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Filter"));
        this.count = nbt.func_74762_e("FilterAmount");
        if (nbt.func_74764_b("ForceScrollable")) {
            this.scrollableValue = this.count;
            this.ticksUntilScrollPacket = -1;
        }
        super.readNBT(nbt);
    }

    @Override
    public CompoundNBT writeToClient(CompoundNBT compound) {
        if (this.forceClientState) {
            compound.func_74757_a("ForceScrollable", true);
            this.forceClientState = false;
        }
        return super.writeToClient(compound);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.getWorld().field_72995_K) {
            return;
        }
        if (this.ticksUntilScrollPacket == -1) {
            return;
        }
        if (this.ticksUntilScrollPacket > 0) {
            --this.ticksUntilScrollPacket;
            return;
        }
        AllPackets.channel.sendToServer((Object)new FilteringCountUpdatePacket(this.getPos(), this.scrollableValue));
        this.ticksUntilScrollPacket = -1;
    }

    public FilteringBehaviour withCallback(Consumer<ItemStack> filterCallback) {
        this.callback = filterCallback;
        return this;
    }

    public FilteringBehaviour onlyActiveWhen(Supplier<Boolean> condition) {
        this.isActive = condition;
        return this;
    }

    public FilteringBehaviour showCount() {
        this.showCount = true;
        return this;
    }

    public FilteringBehaviour moveText(Vec3d shift) {
        this.textShift = shift;
        return this;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.scrollableValue = this.count;
    }

    public void setFilter(ItemStack stack) {
        this.filter = stack.func_77946_l();
        this.callback.accept(this.filter);
        this.count = this.filter.func_77973_b() instanceof FilterItem ? 0 : Math.min(stack.func_190916_E(), stack.func_77976_d());
        this.forceClientState = true;
        this.tileEntity.func_70296_d();
        this.tileEntity.sendData();
    }

    @Override
    public void destroy() {
        if (this.filter.func_77973_b() instanceof FilterItem) {
            Vec3d pos = VecHelper.getCenterOf((Vec3i)this.getPos());
            World world = this.getWorld();
            world.func_217376_c((Entity)new ItemEntity(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, this.filter.func_77946_l()));
        }
        super.destroy();
    }

    public ItemStack getFilter() {
        return this.filter.func_77946_l();
    }

    public boolean isCountVisible() {
        return this.showCount && !this.getFilter().func_190926_b();
    }

    public boolean test(ItemStack stack) {
        return this.filter.func_190926_b() || FilterItem.test(this.tileEntity.func_145831_w(), stack, this.filter);
    }

    @Override
    public IBehaviourType<?> getType() {
        return TYPE;
    }

    public boolean testHit(Vec3d hit) {
        BlockState state = this.tileEntity.func_195044_w();
        Vec3d localHit = hit.func_178788_d(new Vec3d((Vec3i)this.tileEntity.func_174877_v()));
        return this.slotPositioning.testHit(state, localHit);
    }

    public int getAmount() {
        return this.count;
    }

    public boolean anyAmount() {
        return this.count == 0;
    }

    public boolean isActive() {
        return this.isActive.get();
    }
}

