/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public abstract class TileEntityConfigurationPacket<TE extends SyncedTileEntity>
extends SimplePacketBase {
    protected BlockPos pos;

    public TileEntityConfigurationPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.readSettings(buffer);
    }

    public TileEntityConfigurationPacket(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        this.writeSettings(buffer);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            World world = player.field_70170_p;
            if (world == null || world.func_175625_s(this.pos) == null) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s(this.pos);
            if (tileEntity instanceof SyncedTileEntity) {
                this.applySettings((SyncedTileEntity)tileEntity);
                ((SyncedTileEntity)tileEntity).sendData();
                tileEntity.func_70296_d();
            }
        });
        context.get().setPacketHandled(true);
    }

    protected abstract void writeSettings(PacketBuffer var1);

    protected abstract void readSettings(PacketBuffer var1);

    protected abstract void applySettings(TE var1);
}

