/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.ClientSchematicLoader;
import com.simibubi.create.content.schematics.block.SchematicTableContainer;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Label;
import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.gui.widgets.SelectionScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import java.nio.file.Paths;
import java.util.List;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class SchematicTableScreen
extends AbstractSimiContainerScreen<SchematicTableContainer>
implements IHasContainer<SchematicTableContainer> {
    private ScrollInput schematicsArea;
    private IconButton confirmButton;
    private IconButton folderButton;
    private IconButton refreshButton;
    private Label schematicsLabel;
    private final String title = Lang.translate("gui.schematicTable.title", new Object[0]);
    private final String uploading = Lang.translate("gui.schematicTable.uploading", new Object[0]);
    private final String finished = Lang.translate("gui.schematicTable.finished", new Object[0]);
    private final String noSchematics = Lang.translate("gui.schematicTable.noSchematics", new Object[0]);
    private final String availableSchematicsTitle = Lang.translate("gui.schematicTable.availableSchematics", new Object[0]);
    private float progress;
    private float chasingProgress;
    private float lastChasingProgress;

    public SchematicTableScreen(SchematicTableContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
    }

    protected void init() {
        this.setWindowSize(AllGuiTextures.SCHEMATIC_TABLE.width, AllGuiTextures.SCHEMATIC_TABLE.height + 50);
        super.init();
        this.widgets.clear();
        int mainLeft = this.field_147003_i - 56;
        int mainTop = this.field_147009_r - 16;
        CreateClient.schematicSender.refresh();
        List<String> availableSchematics = CreateClient.schematicSender.getAvailableSchematics();
        this.schematicsLabel = new Label(mainLeft + 36, mainTop + 26, "").withShadow();
        this.schematicsLabel.text = "";
        if (!availableSchematics.isEmpty()) {
            this.schematicsArea = new SelectionScrollInput(mainLeft + 33, mainTop + 23, 134, 14).forOptions(availableSchematics).titled(this.availableSchematicsTitle).writingTo(this.schematicsLabel);
            this.widgets.add(this.schematicsArea);
            this.widgets.add(this.schematicsLabel);
        }
        this.confirmButton = new IconButton(mainLeft + 69, mainTop + 55, AllIcons.I_CONFIRM);
        this.folderButton = new IconButton(mainLeft + 204, mainTop + 6, AllIcons.I_OPEN_FOLDER);
        this.refreshButton = new IconButton(mainLeft + 204, mainTop + 26, AllIcons.I_REFRESH);
        this.widgets.add(this.confirmButton);
        this.widgets.add(this.folderButton);
        this.widgets.add(this.refreshButton);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        int x = this.field_147003_i + 20;
        int y = this.field_147009_r;
        int mainLeft = this.field_147003_i - 56;
        int mainTop = this.field_147009_r - 16;
        AllGuiTextures.PLAYER_INVENTORY.draw((AbstractGui)this, x - 16, y + 70 + 14);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), (float)(x - 15 + 7), (float)(y + 64 + 26), 0x666666);
        AllGuiTextures.SCHEMATIC_TABLE.draw((AbstractGui)this, mainLeft, mainTop);
        if (((SchematicTableContainer)this.field_147002_h).getTileEntity().isUploading) {
            this.font.func_211126_b(this.uploading, (float)(mainLeft + 76), (float)(mainTop + 10), 5726074);
        } else if (((SchematicTableContainer)this.field_147002_h).func_75139_a(1).func_75216_d()) {
            this.font.func_211126_b(this.finished, (float)(mainLeft + 60), (float)(mainTop + 10), 5726074);
        } else {
            this.font.func_211126_b(this.title, (float)(mainLeft + 60), (float)(mainTop + 10), 5726074);
        }
        if (this.schematicsArea == null) {
            this.font.func_175063_a(this.noSchematics, (float)(mainLeft + 39), (float)(mainTop + 26), 0xFFDD44);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(mainLeft + 217), (double)(mainTop + 48), (double)200.0);
        RenderSystem.scaled((double)3.0, (double)3.0, (double)3.0);
        GuiGameElement.of(AllBlocks.SCHEMATIC_TABLE.asStack()).render();
        RenderSystem.popMatrix();
        this.minecraft.func_110434_K().func_110577_a(AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.location);
        int width = (int)((float)AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.width * MathHelper.func_219799_g((float)partialTicks, (float)this.lastChasingProgress, (float)this.chasingProgress));
        int height = AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.height;
        RenderSystem.disableLighting();
        this.blit(mainLeft + 94, mainTop + 56, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.startX, AllGuiTextures.SCHEMATIC_TABLE_PROGRESS.startY, width, height);
    }

    public void tick() {
        super.tick();
        boolean finished = ((SchematicTableContainer)this.field_147002_h).func_75139_a(1).func_75216_d();
        if (((SchematicTableContainer)this.field_147002_h).getTileEntity().isUploading || finished) {
            if (finished) {
                this.progress = 1.0f;
                this.lastChasingProgress = 1.0f;
                this.chasingProgress = 1.0f;
            } else {
                this.lastChasingProgress = this.chasingProgress;
                this.progress = ((SchematicTableContainer)this.field_147002_h).getTileEntity().uploadingProgress;
                this.chasingProgress += (this.progress - this.chasingProgress) * 0.5f;
            }
            this.confirmButton.active = false;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(0xCCDDFF);
                this.schematicsLabel.text = ((SchematicTableContainer)this.field_147002_h).getTileEntity().uploadingSchematic;
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.visible = false;
            }
        } else {
            this.progress = 0.0f;
            this.lastChasingProgress = 0.0f;
            this.chasingProgress = 0.0f;
            this.confirmButton.active = true;
            if (this.schematicsLabel != null) {
                this.schematicsLabel.colored(0xFFFFFF);
            }
            if (this.schematicsArea != null) {
                this.schematicsArea.writingTo(this.schematicsLabel);
                this.schematicsArea.visible = true;
            }
        }
    }

    @Override
    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        List<String> availableSchematics;
        ClientSchematicLoader schematicSender = CreateClient.schematicSender;
        if (this.confirmButton.active && this.confirmButton.isHovered() && ((SchematicTableContainer)this.field_147002_h).canWrite() && this.schematicsArea != null) {
            this.progress = 0.0f;
            this.chasingProgress = 0.0f;
            this.lastChasingProgress = 0.0f;
            availableSchematics = schematicSender.getAvailableSchematics();
            String schematic = availableSchematics.get(this.schematicsArea.getState());
            schematicSender.startNewUpload(schematic);
        }
        if (this.folderButton.isHovered()) {
            Util.func_110647_a().func_195641_a(Paths.get("schematics/", new String[0]).toFile());
        }
        if (this.refreshButton.isHovered()) {
            schematicSender.refresh();
            availableSchematics = schematicSender.getAvailableSchematics();
            this.widgets.remove((Object)this.schematicsArea);
            if (!availableSchematics.isEmpty()) {
                this.schematicsArea = new SelectionScrollInput(this.field_147003_i - 56 + 33, this.field_147009_r - 16 + 23, 134, 14).forOptions(availableSchematics).titled(this.availableSchematicsTitle).writingTo(this.schematicsLabel);
                this.widgets.add(this.schematicsArea);
            } else {
                this.schematicsArea = null;
                this.schematicsLabel.text = "";
            }
        }
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }
}

